/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.repository.VocabularyDefinitionRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Vocabulary definitions", description="Datamodel specifications of for vocabulary entities")
@RestController
@RequestMapping(value={"/api/v1/def/vocabularies"})
public class VocabularyDefinitionController
extends BaseRestController<VocabularyDefinition> {
    private static final Logger log = LoggerFactory.getLogger(VocabularyDefinitionController.class);
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;
    @Autowired
    private VocabularyDefinitionRepository vocabularyDefinitionRepo;

    public VocabularyDefinitionController() {
        super("/api/v1/def/vocabularies");
    }

    @PostMapping(consumes={"application/x-yaml", "text/yaml"})
    public void postYaml(@RequestBody String updatedApi, Locale locale) throws JsonMappingException, JsonProcessingException {
        VocabularyDefinition vd = (VocabularyDefinition)this.yamlMapper.readValue(updatedApi, VocabularyDefinition.class);
        this.vocabularyDefinitionRepo.save((Object)vd);
        log.debug("" + vd.getVersion());
    }

    @PostMapping(consumes={"application/json"})
    public void postJson(@RequestBody String updatedApi, Locale locale) throws JsonMappingException, JsonProcessingException {
        JsonNode n = this.jsonMapper.readTree(updatedApi);
        if (n.isArray()) {
            for (JsonNode n1 : n) {
                this.vocabularyDefinitionRepo.save((Object)((VocabularyDefinition)this.jsonMapper.treeToValue((TreeNode)n1, VocabularyDefinition.class)));
            }
        } else {
            this.vocabularyDefinitionRepo.save((Object)((VocabularyDefinition)this.jsonMapper.treeToValue((TreeNode)n, VocabularyDefinition.class)));
        }
    }

    @GetMapping
    public RestItemsResponse get(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection vocabularyDefinitions = this.vocabularyDefinitionRepo.findAllLatest();
        response.setSize((long)vocabularyDefinitions.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(vocabularyDefinitions, request.getRequestURL().toString()));
        return response;
    }

    @GetMapping(value={"{id}"})
    public VocabularyDefinition get(@PathVariable String id, Locale locale) {
        return (VocabularyDefinition)this.vocabularyDefinitionRepo.findById((Object)id).get();
    }

    @GetMapping(value={"/by-name/{name}"})
    public VocabularyDefinition getByName(@PathVariable String name, Locale locale) {
        return this.vocabularyDefinitionRepo.findCurrentByName(name);
    }
}

