/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.PersistedUser;
import de.uniba.minf.registry.model.UserGroup;
import de.uniba.minf.registry.model.UserGroupAssignment;
import de.uniba.minf.registry.pojo.UserGroupAssignmentPojo;
import de.uniba.minf.registry.pojo.converter.UserGroupAssignmentConverter;
import de.uniba.minf.registry.repository.UserGroupRepository;
import de.uniba.minf.registry.repository.UserRepository;
import eu.dariah.de.dariahsp.spring.mvc.model.AuthPojo;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/uga"})
public class UserGroupAssignmentController
extends BaseRestController<UserGroupAssignmentPojo> {
    private static final Logger log = LoggerFactory.getLogger(UserGroupAssignmentController.class);
    @Autowired
    private UserGroupRepository userGroupRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private UserGroupAssignmentConverter userGroupAssignmentConverter;

    public UserGroupAssignmentController() {
        super("/api/v1/uga");
    }

    @GetMapping
    public RestItemsResponse getUserGroupAssignments(HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        RestItemsResponse resp = new RestItemsResponse();
        List assignedGroups = this.userGroupRepository.findByUserUniqueId(authPojo.getUserId());
        ArrayList ugas = new ArrayList();
        for (UserGroup g : assignedGroups) {
            boolean userCanWrite = g.getOwnerUniqueId().equals(authPojo.getUserId()) || g.getUserGroupAssignments().stream().anyMatch(ga -> ga.getUserUniqueId() != null && ga.getUserUniqueId().equals(authPojo.getUserId()) && ga.isWriteAccess());
            List ugaPart = this.userGroupAssignmentConverter.convertPojo(g);
            if (userCanWrite) {
                ugaPart.forEach(uga -> uga.setCurrentUserCanEdit(true));
            }
            ugas.addAll(ugaPart);
        }
        resp.setSize((long)ugas.size());
        resp.setItems(this.getItems(ugas, request.getRequestURL().toString()));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @PostMapping(value={"/{uniqueId}", ""})
    public RestItemsResponse saveNewUserGroup(@PathVariable(required=false) String uniqueId, @RequestBody(required=false) UserGroupAssignmentPojo newGroup, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RestItemsResponse resp;
        UserGroup ug;
        AuthPojo authPojo = this.authInfoHelper.getAuth();
        if (uniqueId != null) {
            Optional optUg = this.userGroupRepository.findById((Object)uniqueId);
            if (!optUg.isPresent()) {
                throw new ApiItemNotFoundException("userGroup", uniqueId);
            }
            ug = (UserGroup)optUg.get();
            resp = this.getUserGroupResponse(ug, request, RestResponse.ApiActions.UPDATED);
        } else {
            ug = new UserGroup();
            ug.setOwnerUniqueId(authPojo.getUserId());
            resp = this.getUserGroupResponse(ug, request, RestResponse.ApiActions.CREATED);
        }
        ug.setName(newGroup.getName());
        this.userGroupRepository.save((Object)ug);
        return resp;
    }

    @PostMapping(value={"/{uniqueId}/user"})
    public RestItemsResponse saveUserInGroup(@PathVariable String uniqueId, @RequestBody UserGroupAssignmentPojo newUga, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        UserGroupAssignment uga;
        Optional user;
        Optional optUg = this.userGroupRepository.findById((Object)uniqueId);
        if (optUg.isEmpty()) {
            throw new ApiItemNotFoundException("userGroup", uniqueId);
        }
        UserGroup ug = (UserGroup)optUg.get();
        if (ug.getUserGroupAssignments() == null) {
            ug.setUserGroupAssignments(new ArrayList());
        }
        if ((user = this.userRepository.findByUsername(newUga.getUsername())).isPresent() && ((PersistedUser)user.get()).getUniqueId().equals(ug.getOwnerUniqueId())) {
            return this.getUserGroupResponse(ug, request, RestResponse.ApiActions.UNCHANGED);
        }
        Optional<UserGroupAssignment> existUga = newUga.getAssignmentUniqueId() != null ? ug.getUserGroupAssignments().stream().filter(u -> u.getUniqueId().equals(newUga.getAssignmentUniqueId())).findFirst() : (user.isPresent() ? ug.getUserGroupAssignments().stream().filter(u -> u.getUserUniqueId() != null && u.getUserUniqueId().equals(((PersistedUser)user.get()).getUniqueId())).findFirst() : ug.getUserGroupAssignments().stream().filter(u -> u.getUsername().equals(newUga.getUsername())).findFirst());
        if (existUga.isPresent()) {
            uga = existUga.get();
        } else {
            uga = new UserGroupAssignment();
            ug.getUserGroupAssignments().add(uga);
        }
        uga.setUsername(newUga.getUsername());
        uga.setUserUniqueId(user.isPresent() ? ((PersistedUser)user.get()).getUniqueId() : null);
        uga.setWriteAccess(newUga.isWriteAccess());
        if (newUga.getExpirationString() != null && !newUga.getExpirationString().isEmpty()) {
            try {
                LocalDate localDate = LocalDate.parse(newUga.getExpirationString(), DateTimeFormatter.ISO_DATE);
                LocalDateTime localDateTime = localDate.atTime(0, 0);
                ZonedDateTime zonedDateTime = localDateTime.atZone(ZoneId.of("UTC"));
                uga.setExpiration(zonedDateTime.toInstant());
            }
            catch (DateTimeParseException ex) {
                log.warn("Failed to parse expiration string", (Throwable)ex);
            }
        } else {
            uga.setExpiration(null);
        }
        this.userGroupRepository.save((Object)ug);
        return this.getUserGroupResponse(ug, request, RestResponse.ApiActions.UPDATED);
    }

    @DeleteMapping(value={"/{uniqueId}/user/{assignmentUniqueId}"})
    public RestItemsResponse removeUserFromGroup(@PathVariable String uniqueId, @PathVariable String assignmentUniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        List<UserGroupAssignment> removeUga;
        Optional optUg = this.userGroupRepository.findById((Object)uniqueId);
        if (optUg.isEmpty()) {
            throw new ApiItemNotFoundException("userGroup", uniqueId);
        }
        UserGroup ug = (UserGroup)optUg.get();
        if (ug.getUserGroupAssignments() != null && !(removeUga = ug.getUserGroupAssignments().stream().filter(uga -> uga.getUniqueId().equals(assignmentUniqueId)).toList()).isEmpty()) {
            ug.getUserGroupAssignments().removeAll(removeUga);
            this.userGroupRepository.save((Object)ug);
            return this.getUserGroupResponse(ug, request, RestResponse.ApiActions.UPDATED);
        }
        return this.getUserGroupResponse(ug, request, RestResponse.ApiActions.UNCHANGED);
    }

    @DeleteMapping(value={"/{uniqueId}"})
    public RestItemsResponse deleteUserGroup(@PathVariable String uniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        Optional optUg = this.userGroupRepository.findById((Object)uniqueId);
        if (optUg.isEmpty()) {
            throw new ApiItemNotFoundException("userGroup", uniqueId);
        }
        this.userGroupRepository.delete((Object)((UserGroup)optUg.get()));
        return this.getUserGroupResponse((UserGroup)optUg.get(), request, RestResponse.ApiActions.DELETED);
    }

    private RestItemsResponse getUserGroupResponse(UserGroup ug, HttpServletRequest request, RestResponse.ApiActions apiAction) {
        RestItemsResponse resp = new RestItemsResponse();
        List uga = this.userGroupAssignmentConverter.convertPojo(ug);
        resp.setAction(apiAction);
        resp.setSize((long)uga.size());
        resp.setItems(this.getItems((Collection)uga, request.getRequestURL().toString()));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }
}

