/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.databind.JsonNode;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.exception.ApiInsufficientPermissionsException;
import de.uniba.minf.core.rest.exception.ApiItemNotFoundException;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.core.rest.model.RestItemResponse;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.core.rest.model.RestResponse;
import de.uniba.minf.registry.model.Import;
import de.uniba.minf.registry.pojo.ImportPojo;
import de.uniba.minf.registry.pojo.converter.ImportConverter;
import de.uniba.minf.registry.repository.ImportRepository;
import de.uniba.minf.registry.service.ImportService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Import", description="Access to records on processed import tasks (actual imports of entities are available with the methods of the entities API methods)")
@RestController
@RequestMapping(value={"/api/v1/imports"})
public class ImportController
extends BaseRestController<ImportPojo> {
    private static final Logger log = LoggerFactory.getLogger(ImportController.class);
    private static final String ITEM_TYPE = "import";
    @Autowired
    private ImportRepository importRepo;
    @Autowired
    private ImportService importService;
    @Autowired
    private ImportConverter importConverter;

    public ImportController() {
        super("/api/v1/imports");
    }

    @GetMapping
    public RestItemsResponse getAllImports(HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        RestItemsResponse resp = new RestItemsResponse();
        Collection imports = this.importConverter.convertPojos((Collection)this.importRepo.findAll());
        resp.setSize((long)imports.size());
        resp.setItems(this.getItems(imports, request.getRequestURL().toString()));
        resp.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        return resp;
    }

    @DeleteMapping(value={"/{uniqueId}"})
    public RestItemResponse deleteImport(@PathVariable String uniqueId, HttpServletRequest request, Locale locale) throws ApiInsufficientPermissionsException, ApiItemNotFoundException {
        Optional i = this.importRepo.findById((Object)uniqueId);
        if (i.isEmpty()) {
            throw new ApiItemNotFoundException(ITEM_TYPE, uniqueId);
        }
        this.importService.deleteImport((Import)i.get());
        return this.getItemResponse((Identifiable)this.importConverter.convertPojo((Import)i.get()), request, RestResponse.ApiActions.DELETED);
    }
}

