/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.uniba.minf.core.rest.controller.BaseRestController;
import de.uniba.minf.core.rest.model.RestItemsResponse;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.repository.EntityDefinitionRepository;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Entity definitions", description="Access to the datamodel specifications of registry entities")
@RestController
@RequestMapping(value={"/api/v1/def/entities"})
public class EntityDefinitionController
extends BaseRestController<EntityDefinition> {
    private static final Logger log = LoggerFactory.getLogger(EntityDefinitionController.class);
    @Autowired
    @Qualifier(value="yamlMapper")
    private ObjectMapper yamlMapper;
    @Autowired
    @Qualifier(value="jsonMapper")
    private ObjectMapper jsonMapper;
    @Autowired
    private EntityDefinitionRepository entityDefinitionRepo;

    public EntityDefinitionController() {
        super("/api/v1/def/entities");
    }

    @PostMapping(consumes={"application/x-yaml", "text/yaml"})
    public void post(@RequestBody String updatedApi, Locale locale) throws JsonMappingException, JsonProcessingException {
        EntityDefinition ed = (EntityDefinition)this.yamlMapper.readValue(updatedApi, EntityDefinition.class);
        this.entityDefinitionRepo.save((Object)ed);
        log.debug("" + ed.getVersion());
    }

    @GetMapping
    public RestItemsResponse get(HttpServletRequest request, Locale locale) {
        RestItemsResponse response = new RestItemsResponse();
        Collection entityDefinitions = this.entityDefinitionRepo.findAllLatest();
        response.setSize((long)entityDefinitions.size());
        response.setLinks((JsonNode)this.getLinks(request.getRequestURL().toString()));
        response.setItems(this.getItems(entityDefinitions, request.getRequestURL().toString()));
        return response;
    }

    @GetMapping(value={"{id}"})
    public EntityDefinition get(@PathVariable String id, Locale locale) {
        return (EntityDefinition)this.entityDefinitionRepo.findById((Object)id).get();
    }

    @GetMapping(value={"/by-name/{name}"})
    public List<EntityDefinition> getByName(@PathVariable String name, Locale locale) {
        return this.entityDefinitionRepo.findByName(name);
    }

    @DeleteMapping(value={"/by-name/{name}"})
    public void deleteByName(@PathVariable String name, Locale locale) {
        this.entityDefinitionRepo.deleteByName(name);
    }
}

