/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config;

import de.unibamberg.minf.core.web.config.LocalizationConfig;
import de.unibamberg.minf.core.web.init.LocaleAwareInitializationService;
import de.unibamberg.minf.core.web.init.LocaleAwareInitializationServiceImpl;
import de.unibamberg.minf.core.web.interceptor.UserLocaleChangeInterceptor;
import de.unibamberg.minf.core.web.localization.MessageSource;
import de.unibamberg.minf.core.web.theming.ThemeManagerImpl;
import eu.dariah.de.dariahsp.spring.mvc.controller.CommonLoginController;
import eu.dariah.de.dariahsp.spring.mvc.controller.SAMLMetadataController;
import java.util.Arrays;
import java.util.Locale;
import javax.annotation.PostConstruct;
import nz.net.ultraq.thymeleaf.layoutdialect.LayoutDialect;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.SortingStrategy;
import nz.net.ultraq.thymeleaf.layoutdialect.decorators.strategies.GroupingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.format.Formatter;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.spring6.ISpringTemplateEngine;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.spring6.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring6.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@ConfigurationProperties
public class WebConfig
implements WebMvcConfigurer,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(WebConfig.class);
    private String contextPath = "";
    private String theme = "textplus-theme";
    private LocalizationConfig localization;
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void completeConfiguration() {
        if (this.localization.getBaseNames() == null) {
            this.localization.setBaseNames(new String[]{"classpath:i18n/messages", "/themes/" + this.theme + "/i18n/theme"});
        }
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> webServerFactoryCustomizer() {
        log.info("Web server context path set to {}", (Object)(this.contextPath.isEmpty() ? "/" : this.contextPath));
        return factory -> factory.setContextPath(this.contextPath);
    }

    @Bean
    public ThemeManagerImpl themeManagerImpl() {
        ThemeManagerImpl themeManagerImpl = new ThemeManagerImpl();
        themeManagerImpl.setTheme("/themes/" + this.theme + "/");
        themeManagerImpl.setCheckExistsSubpaths(Arrays.asList("/i18n/theme_de.properties", "/img/theme-logo.svg"));
        return themeManagerImpl;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.localeChangeInterceptor());
    }

    @Bean
    public SpringResourceTemplateResolver templateResolver() {
        SpringResourceTemplateResolver templateResolver = new SpringResourceTemplateResolver();
        templateResolver.setApplicationContext(this.applicationContext);
        templateResolver.setPrefix("/WEB-INF/views/");
        templateResolver.setSuffix(".html");
        templateResolver.setTemplateMode(TemplateMode.HTML);
        templateResolver.setCacheable(false);
        templateResolver.setCharacterEncoding("UTF-8");
        return templateResolver;
    }

    @Bean
    public SpringTemplateEngine templateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver());
        templateEngine.setEnableSpringELCompiler(true);
        templateEngine.setTemplateEngineMessageSource((org.springframework.context.MessageSource)this.messageSource());
        templateEngine.addDialect((IDialect)new LayoutDialect((SortingStrategy)new GroupingStrategy()));
        return templateEngine;
    }

    @Bean
    public ThymeleafViewResolver viewResolver() {
        ThymeleafViewResolver viewResolver = new ThymeleafViewResolver();
        viewResolver.setTemplateEngine((ISpringTemplateEngine)this.templateEngine());
        viewResolver.setCharacterEncoding("UTF-8");
        viewResolver.setOrder(1);
        return viewResolver;
    }

    @Bean
    public MessageSource messageSource() {
        MessageSource messageSource = new MessageSource();
        messageSource.setBasenames(this.localization.getBaseNames());
        messageSource.setLoggingMode(this.localization.isDebug());
        messageSource.setCacheSeconds(this.localization.getCacheSeconds());
        messageSource.setHideMissingDynamic(this.localization.isHideMissingDynamic());
        messageSource.setReturnMissingCodes(true);
        return messageSource;
    }

    @Bean
    public LocaleAwareInitializationService initService() {
        LocaleAwareInitializationServiceImpl initService = new LocaleAwareInitializationServiceImpl();
        initService.setBasename(this.localization.getBaseNames()[0]);
        log.debug("Initialized LocaleAwareInitializationServiceImpl");
        return initService;
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver localeResolver = new SessionLocaleResolver();
        localeResolver.setDefaultLocale(new Locale("de", "DE"));
        return localeResolver;
    }

    @Bean
    public UserLocaleChangeInterceptor localeChangeInterceptor() {
        UserLocaleChangeInterceptor lci = new UserLocaleChangeInterceptor();
        lci.setInitService(this.initService());
        lci.setParamName("lang");
        return lci;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"/webjars/"});
        registry.addResourceHandler(new String[]{"/resources/**"}).addResourceLocations(new String[]{"/resources/"});
        registry.addResourceHandler(new String[]{"/themes/**"}).addResourceLocations(new String[]{"/themes/"});
        registry.addResourceHandler(new String[]{"/theme/**"}).addResourceLocations(new String[]{"/themes/" + this.theme + "/"});
        registry.addResourceHandler(new String[]{"/favicon.ico"}).addResourceLocations(new String[]{"/resources/favicon.ico"});
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addFormatter((Formatter)this.dateFormatter());
    }

    @Bean
    public DateFormatter dateFormatter() {
        return new DateFormatter();
    }

    @Bean
    public SAMLMetadataController samlMetadataController() {
        return new SAMLMetadataController();
    }

    @Bean
    public CommonLoginController loginLogoutController() {
        return new CommonLoginController();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public LocalizationConfig getLocalization() {
        return this.localization;
    }

    public void setLocalization(LocalizationConfig localization) {
        this.localization = localization;
    }
}

