/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.serialization.EntityDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.EntityDeserializer;
import de.uniba.minf.registry.model.serialization.VocabularyDefinitionDeserializer;
import de.uniba.minf.registry.model.serialization.VocabularyEntryDeserializer;
import de.uniba.minf.registry.model.vocabulary.VocabularyDefinition;
import de.uniba.minf.registry.model.vocabulary.VocabularyEntry;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class SerializationConfig {
    @Bean(value={"jsonMapper"})
    @Primary
    ObjectMapper jsonMapper(SimpleModule serializationModule) {
        ObjectMapper jsonMapper = new ObjectMapper();
        jsonMapper.registerModule((Module)serializationModule);
        jsonMapper.registerModule((Module)this.javaTimeModule());
        jsonMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        jsonMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return jsonMapper;
    }

    @Bean(value={"yamlMapper"})
    ObjectMapper yamlMapper(SimpleModule serializationModule) {
        ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        yamlMapper.registerModule((Module)serializationModule);
        yamlMapper.registerModule((Module)this.javaTimeModule());
        yamlMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        yamlMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return yamlMapper;
    }

    @Bean
    SimpleModule serializationModule(EntityDeserializer entityDeserializer, VocabularyEntryDeserializer vocabularyEntryDeserializer) {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(EntityDefinition.class, (JsonDeserializer)new EntityDefinitionDeserializer());
        module.addDeserializer(Entity.class, (JsonDeserializer)entityDeserializer);
        module.addDeserializer(VocabularyDefinition.class, (JsonDeserializer)new VocabularyDefinitionDeserializer());
        module.addDeserializer(VocabularyEntry.class, (JsonDeserializer)vocabularyEntryDeserializer);
        return module;
    }

    @Bean
    EntityDeserializer entityDeserializer() {
        return new EntityDeserializer();
    }

    @Bean
    VocabularyEntryDeserializer vocabularyEntryDeserializer() {
        return new VocabularyEntryDeserializer();
    }

    @Bean
    JavaTimeModule javaTimeModule() {
        return new JavaTimeModule();
    }
}

