/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.vocabulary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.vocabulary.Reference;
import de.uniba.minf.registry.model.vocabulary.ValueVariant;
import java.util.List;
import java.util.Locale;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
@CompoundIndex(def="{'definitionName': 1, 'key': 1}", unique=true)
public class VocabularyEntry
extends BaseDefinedObject
implements Identifiable {
    private static final long serialVersionUID = -6473574071976021721L;
    @Indexed
    private String key;
    private String primaryValue;
    @Indexed
    private String invertsKey;
    private List<String> parents;
    private List<String> narrower;
    private List<String> ancestors;
    private List<String> broader;
    @Transient
    @JsonIgnore
    private double score;
    private List<ValueVariant> variants;
    private List<Reference> references;

    public String getValueVariant(Locale locale) {
        if (this.variants != null) {
            return this.variants.stream().filter(v -> v.getLang().equals(locale.getLanguage())).findAny().map(v -> v.getValue()).orElse(this.primaryValue);
        }
        return this.primaryValue;
    }

    public String getKey() {
        return this.key;
    }

    public String getPrimaryValue() {
        return this.primaryValue;
    }

    public String getInvertsKey() {
        return this.invertsKey;
    }

    public List<String> getParents() {
        return this.parents;
    }

    public List<String> getNarrower() {
        return this.narrower;
    }

    public List<String> getAncestors() {
        return this.ancestors;
    }

    public List<String> getBroader() {
        return this.broader;
    }

    public double getScore() {
        return this.score;
    }

    public List<ValueVariant> getVariants() {
        return this.variants;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setPrimaryValue(String primaryValue) {
        this.primaryValue = primaryValue;
    }

    public void setInvertsKey(String invertsKey) {
        this.invertsKey = invertsKey;
    }

    public void setParents(List<String> parents) {
        this.parents = parents;
    }

    public void setNarrower(List<String> narrower) {
        this.narrower = narrower;
    }

    public void setAncestors(List<String> ancestors) {
        this.ancestors = ancestors;
    }

    public void setBroader(List<String> broader) {
        this.broader = broader;
    }

    @JsonIgnore
    public void setScore(double score) {
        this.score = score;
    }

    public void setVariants(List<ValueVariant> variants) {
        this.variants = variants;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VocabularyEntry)) {
            return false;
        }
        VocabularyEntry other = (VocabularyEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$primaryValue = this.getPrimaryValue();
        String other$primaryValue = other.getPrimaryValue();
        if (this$primaryValue == null ? other$primaryValue != null : !this$primaryValue.equals(other$primaryValue)) {
            return false;
        }
        String this$invertsKey = this.getInvertsKey();
        String other$invertsKey = other.getInvertsKey();
        if (this$invertsKey == null ? other$invertsKey != null : !this$invertsKey.equals(other$invertsKey)) {
            return false;
        }
        List<String> this$parents = this.getParents();
        List<String> other$parents = other.getParents();
        if (this$parents == null ? other$parents != null : !((Object)this$parents).equals(other$parents)) {
            return false;
        }
        List<String> this$narrower = this.getNarrower();
        List<String> other$narrower = other.getNarrower();
        if (this$narrower == null ? other$narrower != null : !((Object)this$narrower).equals(other$narrower)) {
            return false;
        }
        List<String> this$ancestors = this.getAncestors();
        List<String> other$ancestors = other.getAncestors();
        if (this$ancestors == null ? other$ancestors != null : !((Object)this$ancestors).equals(other$ancestors)) {
            return false;
        }
        List<String> this$broader = this.getBroader();
        List<String> other$broader = other.getBroader();
        if (this$broader == null ? other$broader != null : !((Object)this$broader).equals(other$broader)) {
            return false;
        }
        List<ValueVariant> this$variants = this.getVariants();
        List<ValueVariant> other$variants = other.getVariants();
        if (this$variants == null ? other$variants != null : !((Object)this$variants).equals(other$variants)) {
            return false;
        }
        List<Reference> this$references = this.getReferences();
        List<Reference> other$references = other.getReferences();
        return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VocabularyEntry;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 59 + (int)($score >>> 32 ^ $score);
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $primaryValue = this.getPrimaryValue();
        result = result * 59 + ($primaryValue == null ? 43 : $primaryValue.hashCode());
        String $invertsKey = this.getInvertsKey();
        result = result * 59 + ($invertsKey == null ? 43 : $invertsKey.hashCode());
        List<String> $parents = this.getParents();
        result = result * 59 + ($parents == null ? 43 : ((Object)$parents).hashCode());
        List<String> $narrower = this.getNarrower();
        result = result * 59 + ($narrower == null ? 43 : ((Object)$narrower).hashCode());
        List<String> $ancestors = this.getAncestors();
        result = result * 59 + ($ancestors == null ? 43 : ((Object)$ancestors).hashCode());
        List<String> $broader = this.getBroader();
        result = result * 59 + ($broader == null ? 43 : ((Object)$broader).hashCode());
        List<ValueVariant> $variants = this.getVariants();
        result = result * 59 + ($variants == null ? 43 : ((Object)$variants).hashCode());
        List<Reference> $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "VocabularyEntry(super=" + super.toString() + ", key=" + this.getKey() + ", primaryValue=" + this.getPrimaryValue() + ", invertsKey=" + this.getInvertsKey() + ", parents=" + String.valueOf(this.getParents()) + ", narrower=" + String.valueOf(this.getNarrower()) + ", ancestors=" + String.valueOf(this.getAncestors()) + ", broader=" + String.valueOf(this.getBroader()) + ", score=" + this.getScore() + ", variants=" + String.valueOf(this.getVariants()) + ", references=" + String.valueOf(this.getReferences()) + ")";
    }
}

