/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.PropertyValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class BasePropertyValue<T extends Serializable>
implements PropertyValue {
    private static final long serialVersionUID = 6693821385787060402L;
    private String lang;
    private String reference;
    private T value;
    private String source;

    @Override
    public String asText() {
        return this.value == null ? null : this.value.toString();
    }

    @Override
    public boolean isMultivalue() {
        return false;
    }

    @Override
    public List<PropertyValue> valuesAsList() {
        if (this.getValue() == null) {
            return new ArrayList<PropertyValue>(0);
        }
        ArrayList<PropertyValue> list = new ArrayList<PropertyValue>(1);
        list.add(this);
        return list;
    }

    public boolean isReadOnly() {
        return this.getSource() != null;
    }

    public String getReference() {
        if (this.reference != null || this.value == null) {
            return this.reference;
        }
        if (this.value.toString().toLowerCase().startsWith("http://") || this.value.toString().toLowerCase().startsWith("https://")) {
            return this.value.toString();
        }
        return null;
    }

    @Override
    public String getLang() {
        return this.lang;
    }

    public T getValue() {
        return this.value;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasePropertyValue)) {
            return false;
        }
        BasePropertyValue other = (BasePropertyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasePropertyValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    public String toString() {
        return "BasePropertyValue(lang=" + this.getLang() + ", reference=" + this.getReference() + ", value=" + String.valueOf(this.getValue()) + ", source=" + this.getSource() + ")";
    }

    public BasePropertyValue(String lang, String reference, T value, String source) {
        this.lang = lang;
        this.reference = reference;
        this.value = value;
        this.source = source;
    }

    public BasePropertyValue() {
    }
}

