/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.LongConstraint;
import am.ik.yavi.constraint.ObjectConstraint;
import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.validation.PropertyValidator;
import de.uniba.minf.registry.model.validation.UniqueExternalIdentifierConstraint;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityValidator
extends ValidatorBuilder<Entity> {
    private static final Logger log = LoggerFactory.getLogger(EntityValidator.class);
    private final List<ValidationConfigurationException> configurationExceptions = new ArrayList<ValidationConfigurationException>();
    private final VocabularyLookupService vocabularyLookupService;
    private final ValidationEntityService entityService;
    private final AutoqueryEntityLookupService autoqueryLookupService;

    public EntityValidator(EntityDefinition ed, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService, boolean skipCompleteness) throws ValidationConfigurationException {
        this.vocabularyLookupService = vocabularyLookupService;
        this.entityService = entityService;
        this.autoqueryLookupService = autoqueryLookupService;
        this.buildValidation(ed, skipCompleteness);
        if (!this.getConfigurationExceptions().isEmpty()) {
            this.configurationExceptions.forEach(x -> log.error("Validation configuration error", (Throwable)x));
            throw new ValidationConfigurationException("Errors occurred processing validation configuration", this.configurationExceptions);
        }
    }

    private void buildValidation(EntityDefinition ed, boolean skipCompleteness) {
        this.constraint(BaseDefinedObject::getDefinitionName, "definitionName", c -> (CharSequenceConstraint)c.equalTo((Object)ed.getName())).constraintOnCondition((entity, constraintGroup) -> entity.getDefinitionVersion() > 0L, b -> b.constraint(BaseDefinedObject::getDefinitionVersion, "definitionVersion", c -> (LongConstraint)c.equalTo((Object)ed.getVersion())));
        ed.getExternalIdentifierProperties().stream().forEach(exp -> {
            UniqueExternalIdentifierConstraint uqc = new UniqueExternalIdentifierConstraint(ed, (PropertyDefinition)exp, this.getVocabularyLookupService(), this.getAutoqueryLookupService(), this.entityService);
            this._object(e -> e, exp.getName(), c -> (ObjectConstraint)c.predicate((CustomConstraint)uqc));
        });
        for (PropertyDefinition pd : ed.getAllProperties()) {
            PropertyValidator pv = new PropertyValidator(pd, this.vocabularyLookupService, this.autoqueryLookupService, this.entityService, skipCompleteness);
            this.nest(e -> e.get(pd.getName()), "_prop", pv.build());
            this.configurationExceptions.addAll(pv.getConfigurationExceptions());
        }
    }

    public List<ValidationConfigurationException> getConfigurationExceptions() {
        return this.configurationExceptions;
    }

    public VocabularyLookupService getVocabularyLookupService() {
        return this.vocabularyLookupService;
    }

    public ValidationEntityService getEntityService() {
        return this.entityService;
    }

    public AutoqueryEntityLookupService getAutoqueryLookupService() {
        return this.autoqueryLookupService;
    }
}

