/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.definition;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.uniba.minf.registry.RegistryConstants;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.RelationPropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Transient;

public abstract class PropertyDefinition
implements Serializable {
    private static final long serialVersionUID = 8006255947259478674L;
    private String name;
    private String messageCode;
    private String identifier;
    private boolean mandatory;
    private boolean externalIdentifier;
    private List<String> multilang;
    private String mandatoryGroup;
    private List<String> valid;
    private List<String> multiplicity;
    private String presentationProperty;
    private String imageProcessing;
    private boolean excludeFromQuery;
    private float queryBoost;
    private RegistryConstants.PropertyCompositionMethods compositionMethod = RegistryConstants.PropertyCompositionMethods.DEFAULT;
    private RegistryConstants.PropertyCompositionFlags compositionFlag = RegistryConstants.PropertyCompositionFlags.NONE;

    public boolean isSimple() {
        return this.getClass().equals(SimplePropertyDefinition.class);
    }

    public boolean isVocabulary() {
        return this.getClass().equals(VocabularyPropertyDefinition.class);
    }

    public boolean isRelation() {
        return this.getClass().equals(RelationPropertyDefinition.class);
    }

    public boolean isHierarchical() {
        return HierarchicalPropertyDefinition.class.isAssignableFrom(this.getClass());
    }

    public SimplePropertyDefinition asSimple() {
        return (SimplePropertyDefinition)SimplePropertyDefinition.class.cast(this);
    }

    public VocabularyPropertyDefinition asVocabulary() {
        return (VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(this);
    }

    public HierarchicalPropertyDefinition asHierarchical() {
        return (HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(this);
    }

    public RelationPropertyDefinition asRelation() {
        return (RelationPropertyDefinition)RelationPropertyDefinition.class.cast(this);
    }

    public boolean isValidated() {
        return this.valid != null && !this.valid.isEmpty();
    }

    public boolean isMultiple() {
        return this.multiplicity != null && !this.multiplicity.isEmpty() && (this.multiplicity.size() != 1 || !this.multiplicity.get(0).equals("false"));
    }

    public boolean isMultilingual() {
        return this.multilang != null && !this.multilang.isEmpty() && (this.multilang.size() != 1 || !this.multilang.get(0).equals("false"));
    }

    public boolean isSpecifiedLanguages() {
        return this.isMultilingual() && (this.multilang.size() != 1 || !this.multilang.get(0).equals("true"));
    }

    public List<String> getAllowedLanguages() {
        if (!this.isSpecifiedLanguages()) {
            return new ArrayList<String>(0);
        }
        return this.multilang.stream().filter(l -> !l.equals("true") && !l.equals("false")).toList();
    }

    public boolean isSystem() {
        return this.getName().startsWith("_");
    }

    @JsonIgnore
    @Transient
    public String getIdentifierWithoutEntity() {
        return this.identifier.substring(this.identifier.indexOf(46) + 1);
    }

    public String getMessageCode() {
        if (this.messageCode != null) {
            return this.messageCode;
        }
        if (this.identifier.startsWith("~")) {
            return this.identifier;
        }
        return "~" + this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isExternalIdentifier() {
        return this.externalIdentifier;
    }

    public List<String> getMultilang() {
        return this.multilang;
    }

    public String getMandatoryGroup() {
        return this.mandatoryGroup;
    }

    public List<String> getValid() {
        return this.valid;
    }

    public List<String> getMultiplicity() {
        return this.multiplicity;
    }

    public String getPresentationProperty() {
        return this.presentationProperty;
    }

    public String getImageProcessing() {
        return this.imageProcessing;
    }

    public boolean isExcludeFromQuery() {
        return this.excludeFromQuery;
    }

    public float getQueryBoost() {
        return this.queryBoost;
    }

    public RegistryConstants.PropertyCompositionMethods getCompositionMethod() {
        return this.compositionMethod;
    }

    public RegistryConstants.PropertyCompositionFlags getCompositionFlag() {
        return this.compositionFlag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMessageCode(String messageCode) {
        this.messageCode = messageCode;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public void setExternalIdentifier(boolean externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public void setMultilang(List<String> multilang) {
        this.multilang = multilang;
    }

    public void setMandatoryGroup(String mandatoryGroup) {
        this.mandatoryGroup = mandatoryGroup;
    }

    public void setValid(List<String> valid) {
        this.valid = valid;
    }

    public void setMultiplicity(List<String> multiplicity) {
        this.multiplicity = multiplicity;
    }

    public void setPresentationProperty(String presentationProperty) {
        this.presentationProperty = presentationProperty;
    }

    public void setImageProcessing(String imageProcessing) {
        this.imageProcessing = imageProcessing;
    }

    public void setExcludeFromQuery(boolean excludeFromQuery) {
        this.excludeFromQuery = excludeFromQuery;
    }

    public void setQueryBoost(float queryBoost) {
        this.queryBoost = queryBoost;
    }

    public void setCompositionMethod(RegistryConstants.PropertyCompositionMethods compositionMethod) {
        this.compositionMethod = compositionMethod;
    }

    public void setCompositionFlag(RegistryConstants.PropertyCompositionFlags compositionFlag) {
        this.compositionFlag = compositionFlag;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDefinition)) {
            return false;
        }
        PropertyDefinition other = (PropertyDefinition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMandatory() != other.isMandatory()) {
            return false;
        }
        if (this.isExternalIdentifier() != other.isExternalIdentifier()) {
            return false;
        }
        if (this.isExcludeFromQuery() != other.isExcludeFromQuery()) {
            return false;
        }
        if (Float.compare(this.getQueryBoost(), other.getQueryBoost()) != 0) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$messageCode = this.getMessageCode();
        String other$messageCode = other.getMessageCode();
        if (this$messageCode == null ? other$messageCode != null : !this$messageCode.equals(other$messageCode)) {
            return false;
        }
        String this$identifier = this.getIdentifier();
        String other$identifier = other.getIdentifier();
        if (this$identifier == null ? other$identifier != null : !this$identifier.equals(other$identifier)) {
            return false;
        }
        List<String> this$multilang = this.getMultilang();
        List<String> other$multilang = other.getMultilang();
        if (this$multilang == null ? other$multilang != null : !((Object)this$multilang).equals(other$multilang)) {
            return false;
        }
        String this$mandatoryGroup = this.getMandatoryGroup();
        String other$mandatoryGroup = other.getMandatoryGroup();
        if (this$mandatoryGroup == null ? other$mandatoryGroup != null : !this$mandatoryGroup.equals(other$mandatoryGroup)) {
            return false;
        }
        List<String> this$valid = this.getValid();
        List<String> other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        List<String> this$multiplicity = this.getMultiplicity();
        List<String> other$multiplicity = other.getMultiplicity();
        if (this$multiplicity == null ? other$multiplicity != null : !((Object)this$multiplicity).equals(other$multiplicity)) {
            return false;
        }
        String this$presentationProperty = this.getPresentationProperty();
        String other$presentationProperty = other.getPresentationProperty();
        if (this$presentationProperty == null ? other$presentationProperty != null : !this$presentationProperty.equals(other$presentationProperty)) {
            return false;
        }
        String this$imageProcessing = this.getImageProcessing();
        String other$imageProcessing = other.getImageProcessing();
        if (this$imageProcessing == null ? other$imageProcessing != null : !this$imageProcessing.equals(other$imageProcessing)) {
            return false;
        }
        RegistryConstants.PropertyCompositionMethods this$compositionMethod = this.getCompositionMethod();
        RegistryConstants.PropertyCompositionMethods other$compositionMethod = other.getCompositionMethod();
        if (this$compositionMethod == null ? other$compositionMethod != null : !((Object)((Object)this$compositionMethod)).equals((Object)other$compositionMethod)) {
            return false;
        }
        RegistryConstants.PropertyCompositionFlags this$compositionFlag = this.getCompositionFlag();
        RegistryConstants.PropertyCompositionFlags other$compositionFlag = other.getCompositionFlag();
        return !(this$compositionFlag == null ? other$compositionFlag != null : !((Object)((Object)this$compositionFlag)).equals((Object)other$compositionFlag));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyDefinition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMandatory() ? 79 : 97);
        result = result * 59 + (this.isExternalIdentifier() ? 79 : 97);
        result = result * 59 + (this.isExcludeFromQuery() ? 79 : 97);
        result = result * 59 + Float.floatToIntBits(this.getQueryBoost());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $messageCode = this.getMessageCode();
        result = result * 59 + ($messageCode == null ? 43 : $messageCode.hashCode());
        String $identifier = this.getIdentifier();
        result = result * 59 + ($identifier == null ? 43 : $identifier.hashCode());
        List<String> $multilang = this.getMultilang();
        result = result * 59 + ($multilang == null ? 43 : ((Object)$multilang).hashCode());
        String $mandatoryGroup = this.getMandatoryGroup();
        result = result * 59 + ($mandatoryGroup == null ? 43 : $mandatoryGroup.hashCode());
        List<String> $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        List<String> $multiplicity = this.getMultiplicity();
        result = result * 59 + ($multiplicity == null ? 43 : ((Object)$multiplicity).hashCode());
        String $presentationProperty = this.getPresentationProperty();
        result = result * 59 + ($presentationProperty == null ? 43 : $presentationProperty.hashCode());
        String $imageProcessing = this.getImageProcessing();
        result = result * 59 + ($imageProcessing == null ? 43 : $imageProcessing.hashCode());
        RegistryConstants.PropertyCompositionMethods $compositionMethod = this.getCompositionMethod();
        result = result * 59 + ($compositionMethod == null ? 43 : ((Object)((Object)$compositionMethod)).hashCode());
        RegistryConstants.PropertyCompositionFlags $compositionFlag = this.getCompositionFlag();
        result = result * 59 + ($compositionFlag == null ? 43 : ((Object)((Object)$compositionFlag)).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyDefinition(name=" + this.getName() + ", messageCode=" + this.getMessageCode() + ", identifier=" + this.getIdentifier() + ", mandatory=" + this.isMandatory() + ", externalIdentifier=" + this.isExternalIdentifier() + ", multilang=" + String.valueOf(this.getMultilang()) + ", mandatoryGroup=" + this.getMandatoryGroup() + ", valid=" + String.valueOf(this.getValid()) + ", multiplicity=" + String.valueOf(this.getMultiplicity()) + ", presentationProperty=" + this.getPresentationProperty() + ", imageProcessing=" + this.getImageProcessing() + ", excludeFromQuery=" + this.isExcludeFromQuery() + ", queryBoost=" + this.getQueryBoost() + ", compositionMethod=" + String.valueOf((Object)this.getCompositionMethod()) + ", compositionFlag=" + String.valueOf((Object)this.getCompositionFlag()) + ")";
    }
}

