/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.uniba.minf.registry.RegistryConstants;
import de.uniba.minf.registry.model.BasePropertyValue;
import org.springframework.data.annotation.Transient;

public class TextPropertyValue
extends BasePropertyValue<String> {
    private static final long serialVersionUID = -137603852642783701L;
    @Transient
    @JsonIgnore
    private boolean preventResolution;

    public TextPropertyValue(String value) {
        this.setValue(value);
    }

    public TextPropertyValue(String value, String lang) {
        this.setValue(value);
        this.setLang(lang);
    }

    public TextPropertyValue(String value, String lang, String reference) {
        this.setValue(value);
        this.setLang(lang);
        this.setReference(reference);
    }

    @Override
    public boolean asBoolean() {
        return ((String)this.getValue()).equalsIgnoreCase("true");
    }

    @Override
    public boolean isValidEntityId() {
        return this.getValue() != null && RegistryConstants.UUID_PATTERN.matcher((CharSequence)this.getValue()).matches();
    }

    public boolean isPreventResolution() {
        return this.preventResolution;
    }

    @JsonIgnore
    public void setPreventResolution(boolean preventResolution) {
        this.preventResolution = preventResolution;
    }

    @Override
    public String toString() {
        return "TextPropertyValue(preventResolution=" + this.isPreventResolution() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextPropertyValue)) {
            return false;
        }
        TextPropertyValue other = (TextPropertyValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.isPreventResolution() == other.isPreventResolution();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TextPropertyValue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isPreventResolution() ? 79 : 97);
        return result;
    }

    public TextPropertyValue() {
    }
}

