/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.registry.model.BlockedPropertyValue;
import de.uniba.minf.registry.model.MissingPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Transient;

public class PropertyImpl
implements Property {
    private static final long serialVersionUID = 8048151962532351314L;
    private String label;
    @Transient
    private PropertyDefinition definition;
    private PropertyValue value;
    private List<PropertyList> properties;
    private List<String> propertyKeyOrder;

    public PropertyImpl(PropertyDefinition definition) {
        this.setDefinition(definition);
    }

    @Override
    public PropertyList getProperty(int index) {
        if (this.properties == null || this.properties.size() < index + 1) {
            return null;
        }
        return this.properties.get(index);
    }

    @Override
    public boolean isEmpty() {
        return !(this.value != null && !this.valuesAsList().isEmpty() || this.properties != null && !this.properties.isEmpty());
    }

    @Override
    public List<PropertyValue> valuesAsList() {
        return this.value == null ? new ArrayList<PropertyValue>(0) : this.value.valuesAsList().stream().filter(v -> !MissingPropertyValue.class.isAssignableFrom(v.getClass()) && !BlockedPropertyValue.class.isAssignableFrom(v.getClass())).toList();
    }

    @Override
    public List<String> blockedValues() {
        return this.value == null ? new ArrayList<String>(0) : this.value.valuesAsList().stream().filter(v -> BlockedPropertyValue.class.isAssignableFrom(v.getClass())).map(v -> v.asText()).toList();
    }

    @Override
    public boolean isMissing() {
        return false;
    }

    @Override
    public void removeValues(List<PropertyValue> removeValues) {
        if (this.value != null && removeValues.contains(this.value)) {
            this.value = null;
        } else if (this.value != null && PropertyValueList.class.isAssignableFrom(this.value.getClass())) {
            ((PropertyValueList)PropertyValueList.class.cast(this.value)).getValues().removeAll(removeValues);
        }
    }

    @Override
    public void removeValue(PropertyValue removeValue) {
        if (this.value != null && this.value.equals(removeValue)) {
            this.value = null;
        } else if (this.value != null && PropertyValueList.class.isAssignableFrom(this.value.getClass())) {
            ((PropertyValueList)PropertyValueList.class.cast(this.value)).getValues().remove(removeValue);
        }
    }

    @Override
    public void addValue(PropertyValue value) {
        if (this.getValue() == null) {
            this.setValue(value);
        } else if (this.getValue().isMultivalue()) {
            PropertyValueList values = (PropertyValueList)PropertyValueList.class.cast(this.getValue());
            for (PropertyValue v : value.valuesAsList()) {
                if (values.getValues().contains(v)) continue;
                values.add(v);
            }
        } else if (!this.getValue().equals(value)) {
            PropertyValueList pv = new PropertyValueList();
            pv.add(this.getValue());
            for (PropertyValue v : value.valuesAsList()) {
                if (pv.getValues().contains(v)) continue;
                pv.add(v);
            }
            this.setValue(pv);
        }
    }

    @Override
    public void replaceTextValue(String findVal, String replaceVal) {
        if (this.getValue() != null) {
            if (this.getValue().isMultivalue()) {
                for (PropertyValue v : this.getValue().valuesAsList()) {
                    if (!TextPropertyValue.class.isAssignableFrom(v.getClass()) || !v.asText().equals(findVal)) continue;
                    ((TextPropertyValue)TextPropertyValue.class.cast(v)).setValue(replaceVal);
                }
            } else if (TextPropertyValue.class.isAssignableFrom(this.getValue().getClass()) && this.getValue().asText().equals(findVal)) {
                ((TextPropertyValue)TextPropertyValue.class.cast(this.getValue())).setValue(replaceVal);
            }
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public PropertyDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public PropertyValue getValue() {
        return this.value;
    }

    @Override
    public List<PropertyList> getProperties() {
        return this.properties;
    }

    @Override
    public List<String> getPropertyKeyOrder() {
        return this.propertyKeyOrder;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void setDefinition(PropertyDefinition definition) {
        this.definition = definition;
    }

    @Override
    public void setValue(PropertyValue value) {
        this.value = value;
    }

    @Override
    public void setProperties(List<PropertyList> properties) {
        this.properties = properties;
    }

    @Override
    public void setPropertyKeyOrder(List<String> propertyKeyOrder) {
        this.propertyKeyOrder = propertyKeyOrder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        PropertyDefinition this$definition = this.getDefinition();
        PropertyDefinition other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !((Object)this$definition).equals(other$definition)) {
            return false;
        }
        PropertyValue this$value = this.getValue();
        PropertyValue other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        List<PropertyList> this$properties = this.getProperties();
        List<PropertyList> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        List<String> this$propertyKeyOrder = this.getPropertyKeyOrder();
        List<String> other$propertyKeyOrder = other.getPropertyKeyOrder();
        return !(this$propertyKeyOrder == null ? other$propertyKeyOrder != null : !((Object)this$propertyKeyOrder).equals(other$propertyKeyOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PropertyImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        PropertyDefinition $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : ((Object)$definition).hashCode());
        PropertyValue $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        List<PropertyList> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        List<String> $propertyKeyOrder = this.getPropertyKeyOrder();
        result = result * 59 + ($propertyKeyOrder == null ? 43 : ((Object)$propertyKeyOrder).hashCode());
        return result;
    }

    public String toString() {
        return "PropertyImpl(label=" + this.getLabel() + ", definition=" + String.valueOf(this.getDefinition()) + ", value=" + String.valueOf(this.getValue()) + ", properties=" + String.valueOf(this.getProperties()) + ", propertyKeyOrder=" + String.valueOf(this.getPropertyKeyOrder()) + ")";
    }

    public PropertyImpl() {
    }
}

