/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniqueExternalIdentifierConstraint
implements CustomConstraint<Entity> {
    private static final Logger log = LoggerFactory.getLogger(UniqueExternalIdentifierConstraint.class);
    private final VocabularyLookupService vocabularyLookupService;
    private final AutoqueryEntityLookupService autoqueryLookupService;
    private final ValidationEntityService entityService;
    private final EntityDefinition ed;
    private final PropertyDefinition extIdProperty;

    public UniqueExternalIdentifierConstraint(EntityDefinition ed, PropertyDefinition extIdProperty, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService) {
        this.ed = ed;
        this.extIdProperty = extIdProperty;
        this.vocabularyLookupService = vocabularyLookupService;
        this.autoqueryLookupService = autoqueryLookupService;
        this.entityService = entityService;
    }

    public boolean test(Entity e) {
        List checkedValues = e.get(this.extIdProperty).stream().flatMap(p -> p.valuesAsList().stream()).toList();
        for (PropertyValue checkedValue : checkedValues) {
            if (!this.entityService.findByExternalIdentifier(this.ed.getName(), checkedValue.asText()).stream().anyMatch(matchE -> !matchE.getEntityId().equals(e.getEntityId()))) continue;
            return false;
        }
        return true;
    }

    public String messageKey() {
        return "value.vocabulary_key_identifier_unique";
    }

    public String defaultMessageFormat() {
        return "Property marked as unique and value already in use on another entity";
    }
}

