/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.validation;

import am.ik.yavi.builder.ValidatorBuilder;
import am.ik.yavi.constraint.BooleanConstraint;
import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.DoubleConstraint;
import am.ik.yavi.constraint.IntegerConstraint;
import am.ik.yavi.core.CustomConstraint;
import am.ik.yavi.core.Validator;
import de.uniba.minf.registry.model.BasePropertyValue;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.validation.NumParamConstraint;
import de.uniba.minf.registry.model.validation.QueryVocabularyConstraint;
import de.uniba.minf.registry.model.validation.ValidateUrlConstraint;
import de.uniba.minf.registry.model.validation.ValidationConstants;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import java.util.function.UnaryOperator;

public class PropertyValueValidator<T extends BasePropertyValue<?>>
extends ValidatorBuilder<T> {
    private final Class<T> validatedClass;
    private Validator<T> validator = null;
    private static final ValidateUrlConstraint urlC = new ValidateUrlConstraint();
    private final VocabularyLookupService vocabularyLookupService;
    private final ValidationEntityService entityService;
    private final AutoqueryEntityLookupService autoqueryLookupService;

    public PropertyValueValidator(Class<T> validatedClass, PropertyDefinition pd) throws ValidationConfigurationException {
        this(validatedClass, pd, null, null, null);
    }

    public PropertyValueValidator(Class<T> validatedClass, PropertyDefinition pd, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService) throws ValidationConfigurationException {
        this.validatedClass = validatedClass;
        this.vocabularyLookupService = vocabularyLookupService;
        this.entityService = entityService;
        this.autoqueryLookupService = autoqueryLookupService;
        this.buildValidation(pd);
    }

    public Validator<T> getValidator() {
        if (this.validator == null) {
            this.validator = this.build();
        }
        return this.validator;
    }

    private void buildValidation(PropertyDefinition pd) throws ValidationConfigurationException {
        Enum validationType = null;
        if (SimplePropertyDefinition.class.isAssignableFrom(pd.getClass())) {
            validationType = ((SimplePropertyDefinition)SimplePropertyDefinition.class.cast(pd)).getType();
        }
        if (validationType == null || validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.TEXT) || validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.LONGTEXT) || validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.DATE)) {
            VocabularyPropertyDefinition vpd;
            this.buildTextValidation(pd);
            if (VocabularyPropertyDefinition.class.isAssignableFrom(pd.getClass()) && (vpd = (VocabularyPropertyDefinition)VocabularyPropertyDefinition.class.cast(pd)).isQuery() && vpd.isStrict()) {
                QueryVocabularyConstraint qvc = new QueryVocabularyConstraint(vpd.getVocabulary(), this.getVocabularyLookupService(), this.getAutoqueryLookupService(), this.entityService, vpd.isEntity());
                this.applyStringConstraint(x -> (CharSequenceConstraint)x.predicate((CustomConstraint)qvc));
            }
        } else if (validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT)) {
            this.buildIntegerValidation(pd);
        } else if (validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT)) {
            this.buildDoubleValidation(pd);
        } else if (validationType.equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN)) {
            this.buildBooleanValidation(pd);
        }
    }

    private void buildTextValidation(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.getValid() != null) {
            for (String c : pd.getValid()) {
                NumParamConstraint nC = new NumParamConstraint(c);
                ValidationConstants.ValidationMethods method = nC.getAndAssertValidationMethod();
                if (method.equals((Object)ValidationConstants.ValidationMethods.NOTNULL)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.notNull());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.NOTBLANK)) {
                    this.applyStringConstraint(x -> x.notBlank());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHAN)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.greaterThan(nC.getNum().intValue()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHANOREQUAL)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.greaterThanOrEqual(nC.getNum().intValue()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHAN)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.lessThan(nC.getNum().intValue()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHANOREQUAL)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.lessThanOrEqual(nC.getNum().intValue()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.URL)) {
                    this.applyStringConstraint(x -> (CharSequenceConstraint)x.predicate((CustomConstraint)urlC));
                    continue;
                }
                throw new ValidationConfigurationException("Configured constraint method not applicable to type, method: " + String.valueOf((Object)method) + ", type: text");
            }
        }
    }

    private void buildIntegerValidation(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.getValid() != null) {
            for (String c : pd.getValid()) {
                NumParamConstraint nC = new NumParamConstraint(c);
                ValidationConstants.ValidationMethods method = nC.getAndAssertValidationMethod();
                if (method.equals((Object)ValidationConstants.ValidationMethods.NOTNULL)) {
                    this.applyIntegerConstraint(x -> (IntegerConstraint)x.notNull());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHAN)) {
                    this.applyIntegerConstraint(x -> (IntegerConstraint)x.greaterThan((Object)nC.getNum()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHANOREQUAL)) {
                    this.applyIntegerConstraint(x -> (IntegerConstraint)x.greaterThanOrEqual((Object)nC.getNum()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHAN)) {
                    this.applyIntegerConstraint(x -> (IntegerConstraint)x.lessThan((Object)nC.getNum()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHANOREQUAL)) {
                    this.applyIntegerConstraint(x -> (IntegerConstraint)x.lessThanOrEqual((Object)nC.getNum()));
                    continue;
                }
                throw new ValidationConfigurationException("Configured constraint method not applicable to type, method: " + String.valueOf((Object)method) + ", type: text");
            }
        }
    }

    private void buildDoubleValidation(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.getValid() != null) {
            for (String c : pd.getValid()) {
                NumParamConstraint nC = new NumParamConstraint(c);
                ValidationConstants.ValidationMethods method = nC.getAndAssertValidationMethod();
                if (method.equals((Object)ValidationConstants.ValidationMethods.NOTNULL)) {
                    this.applyDoubleConstraint(x -> (DoubleConstraint)x.notNull());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHAN)) {
                    this.applyDoubleConstraint(x -> (DoubleConstraint)x.greaterThan((Object)nC.numAsDouble()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.GREATERTHANOREQUAL)) {
                    this.applyDoubleConstraint(x -> (DoubleConstraint)x.greaterThanOrEqual((Object)nC.numAsDouble()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHAN)) {
                    this.applyDoubleConstraint(x -> (DoubleConstraint)x.lessThan((Object)nC.numAsDouble()));
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.LESSTHANOREQUAL)) {
                    this.applyDoubleConstraint(x -> (DoubleConstraint)x.lessThanOrEqual((Object)nC.numAsDouble()));
                    continue;
                }
                throw new ValidationConfigurationException("Configured constraint method not applicable to type, method: " + String.valueOf((Object)method) + ", type: text");
            }
        }
    }

    private void buildBooleanValidation(PropertyDefinition pd) throws ValidationConfigurationException {
        if (pd.getValid() != null) {
            for (String c : pd.getValid()) {
                NumParamConstraint nC = new NumParamConstraint(c);
                ValidationConstants.ValidationMethods method = nC.getAndAssertValidationMethod();
                if (method.equals((Object)ValidationConstants.ValidationMethods.NOTNULL)) {
                    this.applyBooleanConstraint(x -> (BooleanConstraint)x.notNull());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.ISTRUE)) {
                    this.applyBooleanConstraint(x -> x.isTrue());
                    continue;
                }
                if (method.equals((Object)ValidationConstants.ValidationMethods.ISFALSE)) {
                    this.applyBooleanConstraint(x -> x.isFalse());
                    continue;
                }
                throw new ValidationConfigurationException("Configured constraint method not applicable to type, method: " + String.valueOf((Object)method) + ", type: text");
            }
        }
    }

    private void applyStringConstraint(UnaryOperator<CharSequenceConstraint<T, String>> c) {
        this._string(x -> x.getValue().toString(), "_" + SimplePropertyDefinition.SIMPLE_TYPES.TEXT.name().toLowerCase(), c);
    }

    private void applyIntegerConstraint(UnaryOperator<IntegerConstraint<T>> c) {
        this._integer(x -> (int)((Integer)x.getValue()), "_" + SimplePropertyDefinition.SIMPLE_TYPES.INT.name().toLowerCase(), c);
    }

    private void applyDoubleConstraint(UnaryOperator<DoubleConstraint<T>> c) {
        this._double(x -> (double)((Double)x.getValue()), "_" + SimplePropertyDefinition.SIMPLE_TYPES.FLOAT.name().toLowerCase(), c);
    }

    private void applyBooleanConstraint(UnaryOperator<BooleanConstraint<T>> c) {
        this._boolean(x -> (boolean)((Boolean)x.getValue()), "_" + SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN.name().toLowerCase(), c);
    }

    public Class<T> getValidatedClass() {
        return this.validatedClass;
    }

    public VocabularyLookupService getVocabularyLookupService() {
        return this.vocabularyLookupService;
    }

    public ValidationEntityService getEntityService() {
        return this.entityService;
    }

    public AutoqueryEntityLookupService getAutoqueryLookupService() {
        return this.autoqueryLookupService;
    }
}

