/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization.base;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.uniba.minf.registry.RegistryConstants;
import de.uniba.minf.registry.model.definition.AutofillPropertyDefinition;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinitionBlock;
import de.uniba.minf.registry.model.definition.RelationPropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.VocabularyPropertyDefinition;
import de.uniba.minf.registry.model.serialization.base.SerializationError;
import de.uniba.minf.registry.model.serialization.base.SerializationMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefinitionDeserializer<T extends BaseDefinition>
extends StdDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseDefinitionDeserializer.class);
    private static final long serialVersionUID = 8050899480597850564L;

    protected BaseDefinitionDeserializer(Class<?> vc) {
        super(vc);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        T def = this.createDefinition(node);
        if (node.has("name")) {
            ((BaseDefinition)def).setLabel(node.get("name").asText());
        }
        if (node.has("code")) {
            ((BaseDefinition)def).setMessageCode(node.get("code").asText());
        }
        if (node.has("system")) {
            ((BaseDefinition)def).setSystem(node.get("system").asBoolean());
        }
        if (node.has("endpoint")) {
            JsonNode endpointNode = node.get("endpoint");
            if (endpointNode.has("url")) {
                ((BaseDefinition)def).setEndpointUrl(endpointNode.get("url").asText());
            }
            if (endpointNode.has("searchUrl")) {
                ((BaseDefinition)def).setEndpointSearchUrl(endpointNode.get("searchUrl").asText());
            }
            if (endpointNode.has("getUrl")) {
                ((BaseDefinition)def).setEndpointGetUrl(endpointNode.get("getUrl").asText());
            }
            if (endpointNode.has("method")) {
                ((BaseDefinition)def).setEndpointMethod(endpointNode.get("method").asText());
            }
        }
        try {
            ((BaseDefinition)def).setPropertyBlocks(new ArrayList<PropertyDefinitionBlock>());
            HashMap<String, PropertyDefinition> propertyIdentifierDefinitionsMap = new HashMap<String, PropertyDefinition>();
            if (node.has("properties") && node.get("properties").isArray()) {
                ((BaseDefinition)def).getPropertyBlocks().add(this.createPropertyDefinitionBlock(node, def, null, propertyIdentifierDefinitionsMap));
            }
            if (node.has("blocks") && node.get("blocks").isArray()) {
                for (JsonNode blockNode : node.get("blocks")) {
                    JsonNode blockLabelNode = blockNode.get("name");
                    if (!blockNode.has("properties") || !blockNode.get("properties").isArray()) continue;
                    ((BaseDefinition)def).getPropertyBlocks().add(this.createPropertyDefinitionBlock(blockNode, def, blockLabelNode != null && blockLabelNode.isTextual() ? blockLabelNode.asText() : null, propertyIdentifierDefinitionsMap));
                }
            }
            if (node.has("preview_properties")) {
                ((BaseDefinition)def).setPreviewPropertyIdentifiers(new ArrayList<String>());
                for (JsonNode prevNode : node.get("preview_properties")) {
                    if (propertyIdentifierDefinitionsMap.containsKey(prevNode.asText())) {
                        ((BaseDefinition)def).getPreviewPropertyIdentifiers().add(prevNode.asText());
                        continue;
                    }
                    if (propertyIdentifierDefinitionsMap.containsKey(((BaseDefinition)def).getName() + "." + prevNode.asText())) {
                        ((BaseDefinition)def).getPreviewPropertyIdentifiers().add(((BaseDefinition)def).getName() + "." + prevNode.asText());
                        continue;
                    }
                    log.warn("Unknown preview property found and skipped: {}", (Object)prevNode.asText());
                }
            }
        }
        catch (SerializationError e) {
            throw new IOException("Failed to deserialize entity definition", e);
        }
        return def;
    }

    protected PropertyDefinitionBlock createPropertyDefinitionBlock(JsonNode node, T def, String blockName, Map<String, PropertyDefinition> propertyIdentifierDefinitionsMap) throws SerializationError {
        PropertyDefinitionBlock block = new PropertyDefinitionBlock();
        block.setProperties(new ArrayList<PropertyDefinition>());
        if (blockName != null) {
            block.setName(blockName);
            block.setIdentifier(((BaseDefinition)def).getName() + "." + blockName);
        }
        if (node.has("properties") && node.get("properties").isArray()) {
            for (JsonNode prop : node.get("properties")) {
                PropertyDefinition propDef = this.deserializePropertyDefinition(def, prop, ((BaseDefinition)def).getName(), propertyIdentifierDefinitionsMap);
                if (propDef == null) continue;
                block.getProperties().add(propDef);
                propertyIdentifierDefinitionsMap.put(propDef.getIdentifier(), propDef);
            }
        }
        return block;
    }

    protected abstract T createDefinition(JsonNode var1);

    private PropertyDefinition deserializePropertyDefinition(T def, JsonNode node, String path, Map<String, PropertyDefinition> propertyIdentifierDefinitionsMap) throws SerializationError {
        if (!this.checkHasField(def, node, "field", false, SerializationMessage.MESSAGE_TYPES.ERROR)) {
            return null;
        }
        String label = node.get("field").textValue();
        path = (String)path + "." + label;
        PropertyDefinition propDef = node.has("properties") ? this.deserializeHierarchicalPropertyDefinition(def, node, (String)path, label, propertyIdentifierDefinitionsMap) : (node.has("entity") ? this.deserializeVocabularyPropertyDefinition(def, node, "entity", true) : (node.has("vocabulary") ? this.deserializeVocabularyPropertyDefinition(def, node, "vocabulary", false) : (node.has("relation") ? this.deserializeRelationPropertyDefinition(def, node, "relation") : this.deserializeSimplePropertyDefinition(def, node))));
        this.deserializePropertyAttributes(propDef, node, (String)path, label);
        return propDef;
    }

    private void deserializePropertyAttributes(PropertyDefinition propDef, JsonNode node, String path, String label) {
        if (propDef != null) {
            propDef.setName(label);
            if (node.has("code")) {
                propDef.setMessageCode(node.get("code").asText());
            }
            propDef.setIdentifier(path);
            this.setMandatory(node, propDef);
            this.setExternalIdentifier(node, propDef);
            propDef.setValid(this.getStringArgs(node, "valid"));
            propDef.setMultilang(this.getStringArgs(node, "multilang"));
            propDef.setMultiplicity(this.getStringArgs(node, "multiple"));
            if (node.has("presentation")) {
                propDef.setPresentationProperty(node.get("presentation").asText());
            }
            if (node.has("image")) {
                propDef.setImageProcessing(node.get("image").asText());
            }
            if (node.has("compositionMethod")) {
                propDef.setCompositionMethod(RegistryConstants.PropertyCompositionMethods.valueOf(node.get("compositionMethod").asText().toUpperCase()));
            }
            if (node.has("compositionFlag")) {
                propDef.setCompositionFlag(RegistryConstants.PropertyCompositionFlags.valueOf(node.get("compositionFlag").asText().toUpperCase()));
            }
        }
    }

    private void setMandatory(JsonNode node, PropertyDefinition propDef) {
        if (node.has("mandatory")) {
            if (node.get("mandatory").isBoolean()) {
                propDef.setMandatory(node.get("mandatory").booleanValue());
                propDef.setMandatoryGroup(null);
            } else {
                propDef.setMandatoryGroup(node.get("mandatory").asText());
                if (propDef.getMandatoryGroup().isBlank()) {
                    propDef.setMandatory(false);
                    propDef.setMandatoryGroup(null);
                } else {
                    propDef.setMandatory(true);
                }
            }
        }
    }

    private List<String> getStringArgs(JsonNode node, String field) {
        ArrayList<String> args;
        block2: {
            block3: {
                args = new ArrayList<String>();
                if (!node.has(field)) break block2;
                if (!node.get(field).isValueNode()) break block3;
                for (String v : node.get(field).asText().split(",")) {
                    args.add(v.trim());
                }
                break block2;
            }
            if (!node.get(field).isArray()) break block2;
            for (JsonNode v : node.get(field)) {
                args.add(v.asText().trim());
            }
        }
        return args;
    }

    private HierarchicalPropertyDefinition deserializeHierarchicalPropertyDefinition(T def, JsonNode node, String path, String label, Map<String, PropertyDefinition> propertyIdentifierDefinitionsMap) throws SerializationError {
        if (!this.checkHasField(def, node, "properties", false, SerializationMessage.MESSAGE_TYPES.ERROR)) {
            return null;
        }
        HierarchicalPropertyDefinition propDef = new HierarchicalPropertyDefinition();
        propDef.setProperties(new ArrayList<PropertyDefinition>());
        for (JsonNode prop : node.get("properties")) {
            PropertyDefinition childPropDef = this.deserializePropertyDefinition(def, prop, path, propertyIdentifierDefinitionsMap);
            if (childPropDef == null) continue;
            propDef.getProperties().add(childPropDef);
            propertyIdentifierDefinitionsMap.put(childPropDef.getIdentifier(), childPropDef);
        }
        return propDef;
    }

    private PropertyDefinition deserializeRelationPropertyDefinition(T def, JsonNode node, String field) throws SerializationError {
        if (!this.checkHasField(def, node, field, false, SerializationMessage.MESSAGE_TYPES.ERROR)) {
            return null;
        }
        RelationPropertyDefinition propDef = new RelationPropertyDefinition();
        propDef.setRelation(node.get(field).textValue());
        return propDef;
    }

    private VocabularyPropertyDefinition deserializeVocabularyPropertyDefinition(T def, JsonNode node, String field, boolean entity) throws SerializationError {
        if (!this.checkHasField(def, node, field, false, SerializationMessage.MESSAGE_TYPES.ERROR)) {
            return null;
        }
        VocabularyPropertyDefinition propDef = new VocabularyPropertyDefinition();
        propDef.setVocabulary(node.get(field).textValue());
        this.setStrictVocabulary(node, propDef);
        if (entity) {
            propDef.setQuery(true);
        } else {
            this.setQueryVocabulary(node, propDef);
        }
        this.setInvertibleVocabulary(node, propDef);
        this.setAutoqueryVocabulary(node, propDef);
        this.setDefaultEntry(node, propDef);
        List<String> autofillArgs = this.getStringArgs(node, "autofill");
        if (!autofillArgs.isEmpty()) {
            ArrayList<AutofillPropertyDefinition> autofillPropertyMap = new ArrayList<AutofillPropertyDefinition>();
            for (String arg : autofillArgs) {
                if (arg.contains("=")) {
                    autofillPropertyMap.add(new AutofillPropertyDefinition(arg.substring(0, arg.indexOf(61)), arg.substring(arg.indexOf(61) + 1)));
                    continue;
                }
                autofillPropertyMap.add(new AutofillPropertyDefinition(arg, null));
            }
            propDef.setAutofillProperties(autofillPropertyMap);
        }
        propDef.setEntity(entity);
        return propDef;
    }

    protected void setStrictVocabulary(JsonNode node, VocabularyPropertyDefinition propDef) {
        if (node.has("strict")) {
            if (node.get("strict").isBoolean()) {
                propDef.setStrict(node.get("strict").asBoolean());
            } else if (node.get("strict").textValue().equals("radio")) {
                propDef.setStrict(true);
                propDef.setRadio(true);
            }
        }
    }

    private void setQueryVocabulary(JsonNode node, VocabularyPropertyDefinition propDef) {
        if (node.has("query")) {
            propDef.setQuery(node.get("query").asBoolean());
        }
    }

    private void setInvertibleVocabulary(JsonNode node, VocabularyPropertyDefinition propDef) {
        if (node.has("invertible")) {
            propDef.setInvertible(node.get("invertible").asBoolean());
        }
    }

    private void setAutoqueryVocabulary(JsonNode node, VocabularyPropertyDefinition propDef) {
        if (node.has("autoquery")) {
            propDef.setAutoQuery(node.get("autoquery").asBoolean());
        }
    }

    private void setExternalIdentifier(JsonNode node, PropertyDefinition propDef) {
        if (node.has("identifier")) {
            propDef.setExternalIdentifier(node.get("identifier").asBoolean());
        }
    }

    private void setDefaultEntry(JsonNode node, VocabularyPropertyDefinition propDef) {
        if (node.has("default")) {
            propDef.setDefaultEntry(node.get("default").asText());
            if (propDef.getDefaultEntry().isBlank()) {
                propDef.setDefaultEntry(null);
            }
        }
    }

    private SimplePropertyDefinition deserializeSimplePropertyDefinition(T def, JsonNode node) throws SerializationError {
        SimplePropertyDefinition propDef = new SimplePropertyDefinition();
        SimplePropertyDefinition.SIMPLE_TYPES type = null;
        if (node.has("type") && node.get("type").isValueNode()) {
            type = SimplePropertyDefinition.SIMPLE_TYPES.valueOf(node.get("type").textValue().toUpperCase());
        }
        if (type == null) {
            ((BaseDefinition)def).addMessage(SerializationMessage.handleMessage(SerializationMessage.MESSAGE_TYPES.NOTICE, "Type on field %s unknown or missing, assuming TEXT", node.get("field").textValue()));
            type = SimplePropertyDefinition.SIMPLE_TYPES.TEXT;
        }
        propDef.setType(type);
        return propDef;
    }

    private boolean checkHasField(T def, JsonNode node, String name, boolean failOnHasField, SerializationMessage.MESSAGE_TYPES messageType) throws SerializationError {
        if (node.has(name) == failOnHasField) {
            String message = String.format("%s: %s", failOnHasField ? "Has invalid field" : "Missing field", name);
            ((BaseDefinition)def).addMessage(SerializationMessage.handleMessage(messageType, message));
            return false;
        }
        return true;
    }
}

