/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.serialization.base;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.BasePropertyValue;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.TextPropertyValue;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDefinedObjectDeserializer<T extends BaseDefinedObject>
extends StdDeserializer<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseDefinedObjectDeserializer.class);
    private static final long serialVersionUID = -873181459316190280L;

    protected BaseDefinedObjectDeserializer(Class<?> c) {
        super(c);
    }

    public void deserialize(T obj, JsonNode node) throws IOException, JacksonException {
        ((BaseDefinedObject)obj).setUniqueId(this.getTextValueIfExists("uniqueId", node));
        ((BaseDefinedObject)obj).setDefinitionName(this.getTextValueIfExists("definition_name", node));
        ((BaseDefinedObject)obj).setDefinitionVersion(this.getIntValue("definition_version", node));
        ((BaseDefinedObject)obj).setReadOnly(this.getBooleanValue("readOnly", node));
        ((BaseDefinedObject)obj).setPublished(this.getBooleanValue("published", node));
        ((BaseDefinedObject)obj).setDraft(this.getBooleanValue("draft", node));
        ((BaseDefinedObject)obj).setValid(this.getBooleanValue("valid", node));
        ((BaseDefinedObject)obj).setTemplate(this.getBooleanValue("template", node));
        ((BaseDefinedObject)obj).setDeleted(this.getBooleanValue("deleted", node));
        ((BaseDefinedObject)obj).setSourceEntityId(this.getTextValueIfExists("sourceId", node));
        ((BaseDefinedObject)obj).setSourceLabel(this.getTextValueIfExists("sourceLabel", node));
        String creation = this.getTextValueIfExists("creation", node);
        if (creation != null) {
            try {
                ((BaseDefinedObject)obj).setCreationInstant(Instant.parse(creation));
            }
            catch (DateTimeParseException e) {
                log.error("Failed to parse creation time with selected formatter", (Throwable)e);
            }
        }
        this.deserializeProperties(obj, node);
        this.deserializeLayers(obj, node);
    }

    private void deserializeProperties(T obj, JsonNode node) {
        ((PropertyList)obj).setProperties(new ArrayList<Property>());
        if (!node.has("properties")) {
            return;
        }
        Iterator propertyFieldIterator = node.get("properties").fields();
        this.collectProperties(propertyFieldIterator, (PropertyList)obj, node);
    }

    private void deserializeLayers(T entity, JsonNode node) {
    }

    private void collectProperties(Iterator<Map.Entry<String, JsonNode>> propertyFieldIterator, PropertyList pl, JsonNode node) {
        while (propertyFieldIterator.hasNext()) {
            Map.Entry<String, JsonNode> propertyEntry = propertyFieldIterator.next();
            PropertyImpl p = new PropertyImpl();
            p.setLabel(propertyEntry.getKey());
            List<PropertyValue> propertyValues = null;
            if (propertyEntry.getValue().isArray() && !propertyEntry.getValue().isEmpty()) {
                if (!propertyEntry.getValue().get(0).isObject() || propertyEntry.getValue().get(0).has("@value") || propertyEntry.getValue().get(0).has("@reference")) {
                    propertyValues = this.collectValues(propertyEntry.getValue());
                } else {
                    p.setProperties(new ArrayList<PropertyList>());
                    this.collectHierarchicalPropertyLists(p.getProperties(), propertyEntry.getValue());
                }
            } else if (propertyEntry.getValue().isObject()) {
                if (propertyEntry.getValue().has("@value") || propertyEntry.getValue().has("@reference")) {
                    propertyValues = this.collectValues(propertyEntry.getValue());
                } else {
                    p.setProperties(new ArrayList<PropertyList>());
                    this.collectHierarchicalPropertyLists(p.getProperties(), propertyEntry.getValue());
                }
            } else {
                propertyValues = this.collectValues(propertyEntry.getValue());
            }
            if (propertyValues != null && !propertyValues.isEmpty()) {
                if (propertyValues.size() == 1) {
                    p.setValue(propertyValues.get(0));
                } else {
                    p.setValue(new PropertyValueList(propertyValues));
                }
            }
            if (p.valuesAsList().isEmpty() && (p.getProperties() == null || p.getProperties().isEmpty())) continue;
            pl.add(p);
        }
    }

    private void collectHierarchicalPropertyLists(List<PropertyList> pl, JsonNode node) {
        if (node.isArray()) {
            for (JsonNode plNode : node) {
                pl.add(this.collectHierarchicalProperties(plNode));
            }
        } else {
            pl.add(this.collectHierarchicalProperties(node));
        }
    }

    private PropertyList collectHierarchicalProperties(JsonNode node) {
        PropertyList pl = new PropertyList();
        Iterator propertyFieldIterator = node.fields();
        this.collectProperties(propertyFieldIterator, pl, node);
        return pl;
    }

    private List<PropertyValue> collectValues(JsonNode node) {
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        if (node.isValueNode()) {
            BasePropertyValue<?> pv = this.getPropertyValue(node);
            if (pv != null) {
                values.add(pv);
            }
        } else if (node.isObject()) {
            BasePropertyValue<?> pv = node.has("@reference") ? this.getPropertyValue(node.get("@reference")) : this.getPropertyValue(node.get("@value"));
            if (pv != null) {
                JsonNode langNode = node.get("@lang");
                if (langNode != null && !langNode.isMissingNode() && !langNode.isNull()) {
                    pv.setLang(node.get("@lang").asText());
                }
                values.add(pv);
            }
        } else {
            for (JsonNode v : node) {
                values.addAll(this.collectValues(v));
            }
        }
        return values;
    }

    private BasePropertyValue<?> getPropertyValue(JsonNode node) {
        if (node == null || node.isMissingNode()) {
            return null;
        }
        if (node.isBoolean()) {
            return new BooleanPropertyValue(node.asBoolean());
        }
        if (node.isDouble()) {
            return new DoublePropertyValue(node.asDouble());
        }
        if (node.isInt()) {
            return new IntegerPropertyValue(node.asInt());
        }
        return new TextPropertyValue(node.asText());
    }

    protected String getTextValueIfExists(String field, JsonNode node) {
        if (node.has(field)) {
            return node.get(field).asText();
        }
        return null;
    }

    protected boolean getBooleanValue(String field, JsonNode node) {
        if (node.has(field)) {
            return node.get(field).asBoolean();
        }
        return false;
    }

    protected int getIntValue(String field, JsonNode node) {
        if (node.has(field)) {
            return node.get(field).asInt();
        }
        return 0;
    }

    protected double getDoubleValue(String field, JsonNode node) {
        if (node.has(field)) {
            return node.get(field).asDouble();
        }
        return 0.0;
    }

    protected long getLongValue(String field, JsonNode node) {
        if (node.has(field)) {
            return node.get(field).asLong();
        }
        return 0L;
    }
}

