/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.helper;

import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyList;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.PropertyValueList;
import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.HierarchicalPropertyDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.entity.Entity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class PropertyDefinitionHelper {
    private PropertyDefinitionHelper() {
    }

    public static List<UnknownProperty> mergeWithDefinition(BaseDefinedObject e, BaseDefinition ed, boolean removeUnknown) {
        e.setDefinitionName(ed.getName());
        e.setDefinitionVersion(ed.getVersion());
        e.setPropertyDefinitions(ed.getAllProperties());
        ArrayList<UnknownProperty> unknownProperties = new ArrayList<UnknownProperty>();
        PropertyDefinitionHelper.mergePropertiesWithDefinitions(ed.getName(), e.getProperties(), ed.getAllProperties(), removeUnknown, unknownProperties);
        return unknownProperties;
    }

    private static void mergePropertiesWithDefinitions(String path, List<Property> ps, List<PropertyDefinition> pds, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        if (ps != null) {
            ArrayList removeProperties = new ArrayList();
            ps.stream().forEach(p -> {
                if (!PropertyDefinitionHelper.mergePropertyWithDefinitions(path, p, pds == null ? Optional.empty() : pds.stream().filter(pd -> pd.getName().equals(p.getLabel())).findFirst(), removeUnknown, unknownProperties)) {
                    removeProperties.add(p);
                }
            });
            if (removeUnknown) {
                ps.removeAll(removeProperties);
            }
        }
    }

    private static void mergePropertyListsWithDefinitions(String path, List<PropertyList> pls, List<PropertyDefinition> pds, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        pls.stream().filter(pl -> pl != null).forEach(pl -> {
            pl.setPropertyDefinitions(pds);
            PropertyDefinitionHelper.mergePropertiesWithDefinitions(path, pl.getProperties(), pds, removeUnknown, unknownProperties);
        });
    }

    private static boolean mergePropertyWithDefinitions(String path, Property p, Optional<PropertyDefinition> pd, boolean removeUnknown, List<UnknownProperty> unknownProperties) {
        String identifier = path + "." + p.getLabel();
        boolean result = true;
        if (pd.isEmpty()) {
            unknownProperties.add(new UnknownProperty(identifier, p.getLabel(), p.getValue() == null ? null : p.getValue().asText()));
            result = false;
        } else {
            p.setDefinition(pd.get());
            if ((pd.get().isSimple() || pd.get().isVocabulary()) && !pd.get().isMultilingual()) {
                p.valuesAsList().forEach(v -> v.setLang(null));
            }
        }
        if (p.getProperties() != null && pd.isPresent() && HierarchicalPropertyDefinition.class.isAssignableFrom(pd.get().getClass())) {
            PropertyDefinitionHelper.mergePropertyListsWithDefinitions(identifier, p.getProperties(), ((HierarchicalPropertyDefinition)HierarchicalPropertyDefinition.class.cast(pd.get())).getProperties(), removeUnknown, unknownProperties);
        } else if (p.getProperties() != null) {
            PropertyDefinitionHelper.mergePropertyListsWithDefinitions(identifier, p.getProperties(), new ArrayList<PropertyDefinition>(0), removeUnknown, unknownProperties);
        }
        return result;
    }

    public static void removeDefinitionsFromEntities(List<Entity> entities) {
        entities.stream().forEach(PropertyDefinitionHelper::removeDefinitionsFromEntity);
    }

    public static void removeDefinitionsFromEntity(Entity entity) {
        entity.setPropertyDefinitions(null);
        PropertyDefinitionHelper.removeDefinitionsFromProperties(entity.getProperties());
    }

    public static void removeDefinitionsFromProperties(List<Property> properties) {
        if (properties == null) {
            return;
        }
        properties.stream().forEach(p -> {
            p.setDefinition(null);
            PropertyDefinitionHelper.removeDefinitionsFromPropertyLists(p.getProperties());
        });
    }

    public static void removeDefinitionsFromPropertyLists(List<PropertyList> propertyLists) {
        if (propertyLists == null) {
            return;
        }
        propertyLists.stream().forEach(p -> {
            p.setPropertyDefinitions(null);
            PropertyDefinitionHelper.removeDefinitionsFromProperties(p.getProperties());
        });
    }

    public static PropertyValue transformIfRequiredAndPossible(PropertyDefinition definition, PropertyValue value) {
        if (value == null || definition == null || !definition.isSimple()) {
            return value;
        }
        SimplePropertyDefinition spd = (SimplePropertyDefinition)SimplePropertyDefinition.class.cast(definition);
        if (PropertyValueList.class.isAssignableFrom(value.getClass())) {
            PropertyValueList result = new PropertyValueList();
            for (PropertyValue v : ((PropertyValueList)PropertyValueList.class.cast(value)).getValues()) {
                result.add(PropertyDefinitionHelper.transformIfRequiredAndPossible(definition, v));
            }
            return result;
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.BOOLEAN) && !BooleanPropertyValue.class.isAssignableFrom(value.getClass())) {
            return new BooleanPropertyValue(value.asText().equalsIgnoreCase("true") || value.asText().equalsIgnoreCase("1"), value.getLang());
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.FLOAT) && !DoublePropertyValue.class.isAssignableFrom(value.getClass())) {
            try {
                return new DoublePropertyValue(Double.parseDouble(value.asText()), value.getLang());
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        if (spd.getType().equals((Object)SimplePropertyDefinition.SIMPLE_TYPES.INT) && !IntegerPropertyValue.class.isAssignableFrom(value.getClass())) {
            try {
                return new IntegerPropertyValue(Integer.parseInt(value.asText()), value.getLang());
            }
            catch (NumberFormatException e) {
                return value;
            }
        }
        return value;
    }

    public static class UnknownProperty {
        private String path;
        private String label;
        private String value;

        public String getPath() {
            return this.path;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UnknownProperty)) {
                return false;
            }
            UnknownProperty other = (UnknownProperty)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$path = this.getPath();
            String other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UnknownProperty;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $path = this.getPath();
            result = result * 59 + ($path == null ? 43 : $path.hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "PropertyDefinitionHelper.UnknownProperty(path=" + this.getPath() + ", label=" + this.getLabel() + ", value=" + this.getValue() + ")";
        }

        public UnknownProperty(String path, String label, String value) {
            this.path = path;
            this.label = label;
            this.value = value;
        }
    }
}

