/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model.entity;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.RelationContainer;
import de.uniba.minf.registry.model.entity.CachedEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

@Document
public class Entity
extends BaseDefinedObject
implements Identifiable {
    private static final long serialVersionUID = -6380999205220429021L;
    @Indexed
    private String entityId;
    @Indexed
    private List<String> layersEntityIds;
    @Transient
    private Map<String, Entity> layers;
    @Transient
    private Entity composite;
    @Indexed
    private String nextVersionUniqueId;
    @Indexed
    private String externalIdentifier;
    @Field(enabled=false)
    private Map<String, CachedEntity> relatedEntityCache;
    Map<String, List<RelationContainer>> implicitRelations;

    public void addLayer(String layerEntityId) {
        if (this.getLayersEntityIds() == null) {
            this.setLayersEntityIds(new ArrayList<String>());
        }
        this.getLayersEntityIds().add(layerEntityId);
    }

    public boolean isComposedEntity() {
        return this.layersEntityIds != null && !this.layersEntityIds.isEmpty();
    }

    public void assureEntityIdAssigned() {
        if (this.entityId == null) {
            this.entityId = UUID.randomUUID().toString();
        }
    }

    public String getEntityId() {
        return this.entityId;
    }

    public List<String> getLayersEntityIds() {
        return this.layersEntityIds;
    }

    public Map<String, Entity> getLayers() {
        return this.layers;
    }

    public Entity getComposite() {
        return this.composite;
    }

    public String getNextVersionUniqueId() {
        return this.nextVersionUniqueId;
    }

    public String getExternalIdentifier() {
        return this.externalIdentifier;
    }

    public Map<String, CachedEntity> getRelatedEntityCache() {
        return this.relatedEntityCache;
    }

    public Map<String, List<RelationContainer>> getImplicitRelations() {
        return this.implicitRelations;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public void setLayersEntityIds(List<String> layersEntityIds) {
        this.layersEntityIds = layersEntityIds;
    }

    public void setLayers(Map<String, Entity> layers) {
        this.layers = layers;
    }

    public void setComposite(Entity composite) {
        this.composite = composite;
    }

    public void setNextVersionUniqueId(String nextVersionUniqueId) {
        this.nextVersionUniqueId = nextVersionUniqueId;
    }

    public void setExternalIdentifier(String externalIdentifier) {
        this.externalIdentifier = externalIdentifier;
    }

    public void setRelatedEntityCache(Map<String, CachedEntity> relatedEntityCache) {
        this.relatedEntityCache = relatedEntityCache;
    }

    public void setImplicitRelations(Map<String, List<RelationContainer>> implicitRelations) {
        this.implicitRelations = implicitRelations;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$entityId = this.getEntityId();
        String other$entityId = other.getEntityId();
        if (this$entityId == null ? other$entityId != null : !this$entityId.equals(other$entityId)) {
            return false;
        }
        List<String> this$layersEntityIds = this.getLayersEntityIds();
        List<String> other$layersEntityIds = other.getLayersEntityIds();
        if (this$layersEntityIds == null ? other$layersEntityIds != null : !((Object)this$layersEntityIds).equals(other$layersEntityIds)) {
            return false;
        }
        Map<String, Entity> this$layers = this.getLayers();
        Map<String, Entity> other$layers = other.getLayers();
        if (this$layers == null ? other$layers != null : !((Object)this$layers).equals(other$layers)) {
            return false;
        }
        Entity this$composite = this.getComposite();
        Entity other$composite = other.getComposite();
        if (this$composite == null ? other$composite != null : !((Object)this$composite).equals(other$composite)) {
            return false;
        }
        String this$nextVersionUniqueId = this.getNextVersionUniqueId();
        String other$nextVersionUniqueId = other.getNextVersionUniqueId();
        if (this$nextVersionUniqueId == null ? other$nextVersionUniqueId != null : !this$nextVersionUniqueId.equals(other$nextVersionUniqueId)) {
            return false;
        }
        String this$externalIdentifier = this.getExternalIdentifier();
        String other$externalIdentifier = other.getExternalIdentifier();
        if (this$externalIdentifier == null ? other$externalIdentifier != null : !this$externalIdentifier.equals(other$externalIdentifier)) {
            return false;
        }
        Map<String, CachedEntity> this$relatedEntityCache = this.getRelatedEntityCache();
        Map<String, CachedEntity> other$relatedEntityCache = other.getRelatedEntityCache();
        if (this$relatedEntityCache == null ? other$relatedEntityCache != null : !((Object)this$relatedEntityCache).equals(other$relatedEntityCache)) {
            return false;
        }
        Map<String, List<RelationContainer>> this$implicitRelations = this.getImplicitRelations();
        Map<String, List<RelationContainer>> other$implicitRelations = other.getImplicitRelations();
        return !(this$implicitRelations == null ? other$implicitRelations != null : !((Object)this$implicitRelations).equals(other$implicitRelations));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Entity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $entityId = this.getEntityId();
        result = result * 59 + ($entityId == null ? 43 : $entityId.hashCode());
        List<String> $layersEntityIds = this.getLayersEntityIds();
        result = result * 59 + ($layersEntityIds == null ? 43 : ((Object)$layersEntityIds).hashCode());
        Map<String, Entity> $layers = this.getLayers();
        result = result * 59 + ($layers == null ? 43 : ((Object)$layers).hashCode());
        Entity $composite = this.getComposite();
        result = result * 59 + ($composite == null ? 43 : ((Object)$composite).hashCode());
        String $nextVersionUniqueId = this.getNextVersionUniqueId();
        result = result * 59 + ($nextVersionUniqueId == null ? 43 : $nextVersionUniqueId.hashCode());
        String $externalIdentifier = this.getExternalIdentifier();
        result = result * 59 + ($externalIdentifier == null ? 43 : $externalIdentifier.hashCode());
        Map<String, CachedEntity> $relatedEntityCache = this.getRelatedEntityCache();
        result = result * 59 + ($relatedEntityCache == null ? 43 : ((Object)$relatedEntityCache).hashCode());
        Map<String, List<RelationContainer>> $implicitRelations = this.getImplicitRelations();
        result = result * 59 + ($implicitRelations == null ? 43 : ((Object)$implicitRelations).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Entity(super=" + super.toString() + ", entityId=" + this.getEntityId() + ", layersEntityIds=" + String.valueOf(this.getLayersEntityIds()) + ", layers=" + String.valueOf(this.getLayers()) + ", composite=" + String.valueOf(this.getComposite()) + ", nextVersionUniqueId=" + this.getNextVersionUniqueId() + ", externalIdentifier=" + this.getExternalIdentifier() + ", relatedEntityCache=" + String.valueOf(this.getRelatedEntityCache()) + ", implicitRelations=" + String.valueOf(this.getImplicitRelations()) + ")";
    }
}

