/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.uniba.minf.registry.model.Property;
import de.uniba.minf.registry.model.PropertyImpl;
import de.uniba.minf.registry.model.PropertyList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.annotation.Transient;

public class CompositePropertyImpl
extends PropertyImpl {
    private static final long serialVersionUID = -8393661481293626596L;
    @Transient
    private boolean layersOnly;
    @Transient
    @JsonIgnore
    private Map<String, Property> layeredPropertyMap;
    private List<String> propertyLayerEntityIds;

    @Override
    public boolean isComposite() {
        return true;
    }

    @Transient
    public boolean hasLayeredData() {
        return this.propertyLayerEntityIds != null && !this.propertyLayerEntityIds.isEmpty();
    }

    public List<String> getLayersForPropertyValue(Object value) {
        if (value == null || this.layeredPropertyMap == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> layerIds = new ArrayList<String>();
        for (Map.Entry<String, Property> propertyLayerEntry : this.layeredPropertyMap.entrySet()) {
            if (!propertyLayerEntry.getValue().valuesAsList().stream().anyMatch(v -> v.asText().equals(value.toString()))) continue;
            layerIds.add(propertyLayerEntry.getKey());
        }
        return layerIds;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && !this.hasLayeredData();
    }

    public Property toRegularProperty() {
        return CompositePropertyImpl.toRegularProperty(this);
    }

    public static Property toRegularProperty(Property pComp) {
        PropertyImpl p = new PropertyImpl();
        p.setDefinition(pComp.getDefinition());
        p.setLabel(pComp.getLabel());
        p.setValue(pComp.getValue());
        p.setPropertyKeyOrder(pComp.getPropertyKeyOrder());
        if (pComp.getProperties() != null) {
            p.setProperties(new ArrayList<PropertyList>(pComp.getProperties().size()));
            for (PropertyList plCompSub : pComp.getProperties()) {
                PropertyList plSub = new PropertyList();
                for (Property pCompSub : plCompSub.getProperties()) {
                    plSub.add(CompositePropertyImpl.toRegularProperty(pCompSub));
                }
                p.getProperties().add(plSub);
            }
        }
        return p;
    }

    public boolean isLayersOnly() {
        return this.layersOnly;
    }

    public Map<String, Property> getLayeredPropertyMap() {
        return this.layeredPropertyMap;
    }

    public List<String> getPropertyLayerEntityIds() {
        return this.propertyLayerEntityIds;
    }

    public void setLayersOnly(boolean layersOnly) {
        this.layersOnly = layersOnly;
    }

    @JsonIgnore
    public void setLayeredPropertyMap(Map<String, Property> layeredPropertyMap) {
        this.layeredPropertyMap = layeredPropertyMap;
    }

    public void setPropertyLayerEntityIds(List<String> propertyLayerEntityIds) {
        this.propertyLayerEntityIds = propertyLayerEntityIds;
    }

    @Override
    public String toString() {
        return "CompositePropertyImpl(layersOnly=" + this.isLayersOnly() + ", layeredPropertyMap=" + String.valueOf(this.getLayeredPropertyMap()) + ", propertyLayerEntityIds=" + String.valueOf(this.getPropertyLayerEntityIds()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompositePropertyImpl)) {
            return false;
        }
        CompositePropertyImpl other = (CompositePropertyImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLayersOnly() != other.isLayersOnly()) {
            return false;
        }
        Map<String, Property> this$layeredPropertyMap = this.getLayeredPropertyMap();
        Map<String, Property> other$layeredPropertyMap = other.getLayeredPropertyMap();
        if (this$layeredPropertyMap == null ? other$layeredPropertyMap != null : !((Object)this$layeredPropertyMap).equals(other$layeredPropertyMap)) {
            return false;
        }
        List<String> this$propertyLayerEntityIds = this.getPropertyLayerEntityIds();
        List<String> other$propertyLayerEntityIds = other.getPropertyLayerEntityIds();
        return !(this$propertyLayerEntityIds == null ? other$propertyLayerEntityIds != null : !((Object)this$propertyLayerEntityIds).equals(other$propertyLayerEntityIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CompositePropertyImpl;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLayersOnly() ? 79 : 97);
        Map<String, Property> $layeredPropertyMap = this.getLayeredPropertyMap();
        result = result * 59 + ($layeredPropertyMap == null ? 43 : ((Object)$layeredPropertyMap).hashCode());
        List<String> $propertyLayerEntityIds = this.getPropertyLayerEntityIds();
        result = result * 59 + ($propertyLayerEntityIds == null ? 43 : ((Object)$propertyLayerEntityIds).hashCode());
        return result;
    }
}

