/*
 * Decompiled with CFR 0.152.
 */
package de.uniba.minf.registry.model;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.PropertyList;
import java.time.Instant;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;

public abstract class BaseDefinedObject
extends PropertyList
implements Identifiable {
    private static final long serialVersionUID = -7366410799469808617L;
    @Id
    private String uniqueId;
    @Indexed
    private String definitionName;
    private long definitionVersion;
    private Instant creationInstant;
    private String userUniqueId;
    private boolean readOnly;
    private boolean draft;
    private boolean valid;
    private boolean template;
    private boolean deleted;
    @Indexed
    private String importId;
    @Indexed
    private String sourceEntityId;
    private String sourceLabel;
    private String sourceTitle;

    public boolean isPublished() {
        return !this.draft;
    }

    public void setPublished(boolean published) {
        this.draft = !published;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getDefinitionName() {
        return this.definitionName;
    }

    public long getDefinitionVersion() {
        return this.definitionVersion;
    }

    public Instant getCreationInstant() {
        return this.creationInstant;
    }

    public String getUserUniqueId() {
        return this.userUniqueId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isTemplate() {
        return this.template;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public String getImportId() {
        return this.importId;
    }

    public String getSourceEntityId() {
        return this.sourceEntityId;
    }

    public String getSourceLabel() {
        return this.sourceLabel;
    }

    public String getSourceTitle() {
        return this.sourceTitle;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setDefinitionName(String definitionName) {
        this.definitionName = definitionName;
    }

    public void setDefinitionVersion(long definitionVersion) {
        this.definitionVersion = definitionVersion;
    }

    public void setCreationInstant(Instant creationInstant) {
        this.creationInstant = creationInstant;
    }

    public void setUserUniqueId(String userUniqueId) {
        this.userUniqueId = userUniqueId;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setTemplate(boolean template) {
        this.template = template;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setImportId(String importId) {
        this.importId = importId;
    }

    public void setSourceEntityId(String sourceEntityId) {
        this.sourceEntityId = sourceEntityId;
    }

    public void setSourceLabel(String sourceLabel) {
        this.sourceLabel = sourceLabel;
    }

    public void setSourceTitle(String sourceTitle) {
        this.sourceTitle = sourceTitle;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDefinedObject)) {
            return false;
        }
        BaseDefinedObject other = (BaseDefinedObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDefinitionVersion() != other.getDefinitionVersion()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        if (this.isDraft() != other.isDraft()) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        if (this.isTemplate() != other.isTemplate()) {
            return false;
        }
        if (this.isDeleted() != other.isDeleted()) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        String this$definitionName = this.getDefinitionName();
        String other$definitionName = other.getDefinitionName();
        if (this$definitionName == null ? other$definitionName != null : !this$definitionName.equals(other$definitionName)) {
            return false;
        }
        Instant this$creationInstant = this.getCreationInstant();
        Instant other$creationInstant = other.getCreationInstant();
        if (this$creationInstant == null ? other$creationInstant != null : !((Object)this$creationInstant).equals(other$creationInstant)) {
            return false;
        }
        String this$userUniqueId = this.getUserUniqueId();
        String other$userUniqueId = other.getUserUniqueId();
        if (this$userUniqueId == null ? other$userUniqueId != null : !this$userUniqueId.equals(other$userUniqueId)) {
            return false;
        }
        String this$importId = this.getImportId();
        String other$importId = other.getImportId();
        if (this$importId == null ? other$importId != null : !this$importId.equals(other$importId)) {
            return false;
        }
        String this$sourceEntityId = this.getSourceEntityId();
        String other$sourceEntityId = other.getSourceEntityId();
        if (this$sourceEntityId == null ? other$sourceEntityId != null : !this$sourceEntityId.equals(other$sourceEntityId)) {
            return false;
        }
        String this$sourceLabel = this.getSourceLabel();
        String other$sourceLabel = other.getSourceLabel();
        if (this$sourceLabel == null ? other$sourceLabel != null : !this$sourceLabel.equals(other$sourceLabel)) {
            return false;
        }
        String this$sourceTitle = this.getSourceTitle();
        String other$sourceTitle = other.getSourceTitle();
        return !(this$sourceTitle == null ? other$sourceTitle != null : !this$sourceTitle.equals(other$sourceTitle));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseDefinedObject;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $definitionVersion = this.getDefinitionVersion();
        result = result * 59 + (int)($definitionVersion >>> 32 ^ $definitionVersion);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        result = result * 59 + (this.isDraft() ? 79 : 97);
        result = result * 59 + (this.isValid() ? 79 : 97);
        result = result * 59 + (this.isTemplate() ? 79 : 97);
        result = result * 59 + (this.isDeleted() ? 79 : 97);
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        String $definitionName = this.getDefinitionName();
        result = result * 59 + ($definitionName == null ? 43 : $definitionName.hashCode());
        Instant $creationInstant = this.getCreationInstant();
        result = result * 59 + ($creationInstant == null ? 43 : ((Object)$creationInstant).hashCode());
        String $userUniqueId = this.getUserUniqueId();
        result = result * 59 + ($userUniqueId == null ? 43 : $userUniqueId.hashCode());
        String $importId = this.getImportId();
        result = result * 59 + ($importId == null ? 43 : $importId.hashCode());
        String $sourceEntityId = this.getSourceEntityId();
        result = result * 59 + ($sourceEntityId == null ? 43 : $sourceEntityId.hashCode());
        String $sourceLabel = this.getSourceLabel();
        result = result * 59 + ($sourceLabel == null ? 43 : $sourceLabel.hashCode());
        String $sourceTitle = this.getSourceTitle();
        result = result * 59 + ($sourceTitle == null ? 43 : $sourceTitle.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseDefinedObject(super=" + super.toString() + ", uniqueId=" + this.getUniqueId() + ", definitionName=" + this.getDefinitionName() + ", definitionVersion=" + this.getDefinitionVersion() + ", creationInstant=" + String.valueOf(this.getCreationInstant()) + ", userUniqueId=" + this.getUserUniqueId() + ", readOnly=" + this.isReadOnly() + ", draft=" + this.isDraft() + ", valid=" + this.isValid() + ", template=" + this.isTemplate() + ", deleted=" + this.isDeleted() + ", importId=" + this.getImportId() + ", sourceEntityId=" + this.getSourceEntityId() + ", sourceLabel=" + this.getSourceLabel() + ", sourceTitle=" + this.getSourceTitle() + ")";
    }
}

