package de.uniba.minf.registry.model.vocabulary;


import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class VocabularyLookupException extends Exception {
	private static final long serialVersionUID = -4416587039415066421L;

	private final String vocabulary;
	private final String id;
	private final boolean remoteIssue;
	
	public VocabularyLookupException(String vocabulary, String id, boolean remoteIssue) {
		this(vocabulary, id, remoteIssue, null, null);
	}
	
	public VocabularyLookupException(String vocabulary, String id, boolean remoteIssue, String message) {
		this(vocabulary, id, remoteIssue, message, null);
	}
	
	public VocabularyLookupException(String vocabulary, String id, boolean remoteIssue, String message, Throwable cause) {
		super(message, cause);
		this.vocabulary = vocabulary;
		this.id = id;
		this.remoteIssue = remoteIssue;
	}
}