package de.uniba.minf.registry.model.validation;

import am.ik.yavi.core.ViolationMessage;
import de.uniba.minf.registry.model.BooleanPropertyValue;
import de.uniba.minf.registry.model.DoublePropertyValue;
import de.uniba.minf.registry.model.IntegerPropertyValue;

public class ValidationConstants {
	public static final String VALIDATION_PROPERTY_TRUE_VALUE = "true";
	public static final String VALIDATION_PROPERTY_FALSE_VALUE = "false";
	public static final String VALIDATION_METADATA_PROPERTIES = "_prop";
	public static final String VALIDATION_METADATA_VALUE = "_val";
	public static final String VALIDATION_METADATA_SKIPLEVEL = "_valList";
	public static final String VALIDATION_METADATA_MULTIPLICITY = "_multiplicity";
	public static final String VALIDATION_METADATA_MANDATORY = "_mandatory";
	
	public enum ValidationMethods {
		NOTNULL (false),
		NOTBLANK (false),
		ISTRUE (false),
		ISFALSE (false),
		URL (false),
		
		MIN (true),
		MAX (true),
		FIXED (true),
		GREATERTHAN (true),
		GREATERTHANOREQUAL (true),
		LESSTHAN (true),
		LESSTHANOREQUAL (true);
		
		private final boolean numArgRequired;       
				
		public boolean getNumArgRequired() { return numArgRequired; }
				
		private ValidationMethods(boolean numArgRequired) {
	    	this.numArgRequired = numArgRequired;
	    }
	}
	
	public enum CustomViolationMessages implements ViolationMessage {
		VALUE_NOT_INTEGER("checkClass:IntegerPropertyValue", "value.isInteger", "\"{0}\" must be a numeric (integer) value"),
		VALUE_NOT_FLOAT("checkClass:DoublePropertyValue", "value.isFloat", "\"{0}\" must be a numeric (floating point) value"),
		VALUE_NOT_BOOLEAN("checkClass:BooleanPropertyValue", "value.isBoolean", "\"{0}\" must be a boolean (true or false) value");
		
		private final String defaultMessageFormat;
		private final String key;
		private final String messageKey;

		CustomViolationMessages(String key, String messageKey, String defaultMessageFormat) {
			this.messageKey = messageKey;
			this.key = key;
			this.defaultMessageFormat = defaultMessageFormat;
		}

		@Override
		public String defaultMessageFormat() {
			return this.defaultMessageFormat;
		}

		@Override
		public String messageKey() {
			return this.messageKey;
		}
		
		public String key() {
			return key;
		}
	}
	
	private ValidationConstants() {
	    throw new IllegalStateException("Utility class");
	}
}
