package de.uniba.minf.registry.model.validation;

import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupException;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class QueryVocabularyConstraint implements CustomConstraint<String> {

	private final VocabularyLookupService vocabularyLookupService;
	private final AutoqueryEntityLookupService autoqueryLookupService;
	private final ValidationEntityService entityService;
	private final String vocabulary;
	private final boolean entity;
	
	public QueryVocabularyConstraint(String vocabulary, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService, boolean entity) {
		this.vocabulary = vocabulary;
		this.vocabularyLookupService = vocabularyLookupService;
		this.autoqueryLookupService = autoqueryLookupService;
		this.entityService = entityService;
		this.entity = entity;
	}
	
	@Override
	public boolean test(String id) {
		try {
			if (!entity) {
				return vocabularyLookupService.canResolveId(vocabulary, id);
			}
			if (entityService.findLatestByEntityId(id).isPresent()) {
				return true;
			}
			if (!entityService.findByExternalIdentifier(vocabulary, id).isEmpty()) {
				return true;
			}
			return autoqueryLookupService.canResolveId(vocabulary, id);
			
		} catch (VocabularyLookupException e) {
			log.error("Failed to resolve vocabulary entry", e);
			return false;
		}
	}
	
    @Override
    public String messageKey() {
        return "value.vocabulary_key_unknown";
    }

    @Override
    public String defaultMessageFormat() {
        return "Selection of a valid vocabulary entry required";
    }

}
