package de.uniba.minf.registry.model.serialization.exception;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
public class SerializationException extends Exception {
	private static final long serialVersionUID = -6644972735489205686L;

	public enum Direction { SERIALIZATION, DESERIALIZATION }
	
	private final Direction direction;
	private final String definitionName;
	private final long definitionVersion;
	
	public SerializationException(Direction direction, String definitionName, long definitionVersion, String message) {
		super(message);
		this.direction = direction;
		this.definitionName = definitionName;
		this.definitionVersion = definitionVersion;
	}
}
