package de.uniba.minf.registry.model.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.BaseDefinedObject;
import de.uniba.minf.registry.model.RelationContainer;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@Document
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class Entity extends BaseDefinedObject implements Identifiable {
	private static final long serialVersionUID = -6380999205220429021L;

	/**
	 * Persistent identifier of the entity
	 */
	@Indexed
	private String entityId;
	
	@Indexed
	private List<String> layersEntityIds;
	
	@Transient
	private Map<String, Entity> layers;
	
	@Transient
	private Entity composite;
	
	@Indexed
	private String nextVersionUniqueId;
	
	@Indexed
	private String externalIdentifier;
	
	@Field(enabled = false)
	private Map<String, CachedEntity> relatedEntityCache;

	Map<String, List<RelationContainer>> implicitRelations;
	
	private boolean valid;
	
	public void addLayer(String layerEntityId) {
		if (this.getLayersEntityIds()==null) {
			this.setLayersEntityIds(new ArrayList<>());
		}
		this.getLayersEntityIds().add(layerEntityId);
	}
	
	public boolean isComposedEntity() {
		return this.layersEntityIds!=null && !this.layersEntityIds.isEmpty();
	}
	
	public void assureEntityIdAssigned() {
		if (this.entityId==null) {
			this.entityId = UUID.randomUUID().toString();
		}
	}
}