package de.uniba.minf.registry.model;

import static de.uniba.minf.registry.RegistryConstants.UUID_PATTERN;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper=true)
@NoArgsConstructor
public class TextPropertyValue extends BasePropertyValue<String> {
		
	private static final long serialVersionUID = -137603852642783701L;

	public TextPropertyValue(String value) {
		this.setValue(value);
	}
	
	public TextPropertyValue(String value, String lang) {
		this.setValue(value);
		this.setLang(lang);
	}
	
	public TextPropertyValue(String value, String lang, String reference) {
		this.setValue(value);
		this.setLang(lang);
		this.setReference(reference);
	}
	
	@Transient
	@JsonIgnore
	private boolean preventResolution;
	
	@Override
	public boolean asBoolean() {
		return this.getValue().equalsIgnoreCase("true");
	}
	
	@Override
	public boolean isValidEntityId() {
		return this.getValue()!=null && UUID_PATTERN.matcher(this.getValue()).matches();
	}
}
