package de.uniba.minf.registry.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import de.uniba.minf.registry.model.definition.PropertyDefinition;

public interface Property extends Serializable {
	public String getLabel();
	public void setLabel(String label);
	
	public PropertyValue getValue();
	public void setValue(PropertyValue value);
	
	public List<PropertyList> getProperties();
	public void setProperties(List<PropertyList> properties);
	
	public PropertyList getProperty(int index);
	
	public PropertyDefinition getDefinition();
	public void setDefinition(PropertyDefinition definition);
	
	public List<PropertyValue> valuesAsList();
	public default List<String> blockedValues() { return new ArrayList<>(); }
	
	public default List<String> getPropertyKeyOrder() { return null; }
	public default void setPropertyKeyOrder(List<String> propertyKeyOrder) {}
	
	public void removeValues(List<PropertyValue> removeValues);
	public void removeValue(PropertyValue removeValue);
	
	public default boolean isComposite() { return false; }
	public boolean isMissing();
	
	public void addValue(PropertyValue value);
	
	public boolean isEmpty();
	public void replaceTextValue(String findVal, String replaceVal);
}
