package de.uniba.minf.registry.model;

import java.util.ArrayList;
import java.util.List;
import de.uniba.minf.registry.model.definition.PropertyDefinition;

public class MissingProperty implements Property {
	private static final long serialVersionUID = -3388479911153545494L;
	
	private static final MissingProperty instance = new MissingProperty();
	
	public static MissingProperty getInstance() { return instance; }
	
	private MissingProperty() { }

	 
	@Override public String getLabel() { return null; }

	@Override public void setLabel(String label) {
		throw new UnsupportedOperationException();
	}

	@Override public PropertyValue getValue() { return MissingPropertyValue.getInstance(); }

	@Override public void setValue(PropertyValue value) { 
		throw new UnsupportedOperationException();
	}

	@Override public List<PropertyList> getProperties() { return new ArrayList<>(0); }

	@Override public void setProperties(List<PropertyList> properties) { 
		throw new UnsupportedOperationException();
	}

	@Override public PropertyList getProperty(int index) { return null; }

	@Override public List<PropertyValue> valuesAsList() { return new ArrayList<>(0); }

	@Override public PropertyDefinition getDefinition() { return null; }

	@Override public void setDefinition(PropertyDefinition definition) { }
	
	@Override public boolean isMissing() { return true; }
	
	@Override public boolean isEmpty() { return true; }
	
	@Override public void removeValues(List<PropertyValue> removeValues) { }

	@Override public void removeValue(PropertyValue removeValue) { }

	@Override public void addValue(PropertyValue value) { }

	@Override
	public void replaceTextValue(String findVal, String replaceVal) { }
}
