package de.uniba.minf.registry.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public abstract class BasePropertyValue<T extends Serializable> implements PropertyValue {
	private static final long serialVersionUID = 6693821385787060402L;
	
	private String lang;
	private String reference;			// can be explicitly set or rendered from a link value
	private T value;
	private String source;				// Populated from autoquery vocabulary
	//private String layerEntityId;
	
		
	@Override
	public String asText() {
		return value==null ? null : value.toString();
	}
	
	@Override
	public boolean isMultivalue() {
		return false;
	}
	
	@Override
	public List<PropertyValue> valuesAsList() {
		if (this.getValue()==null) {
			return new ArrayList<>(0);
		}
		List<PropertyValue> list = new ArrayList<>(1);
		list.add(this);
		return list;
	}
	
	public boolean isReadOnly() {
		return this.getSource()!=null/* || this.getLayerEntityId()!=null*/;
	} 
	
	public String getReference() {
		if (reference!=null || value==null) {
			return reference;
		}
		if (value.toString().toLowerCase().startsWith("http://") || value.toString().toLowerCase().startsWith("https://")) {
			return value.toString();
		}
		return null;
	}
}
