package de.uniba.minf.registry.model.vocabulary;

import java.util.List;

public interface VocabularyLookupService {
	public boolean canResolveId(String vocabulary, String id) throws VocabularyLookupException;
	public List<VocabularyEntry> search(String vocabulary, String query) throws VocabularyLookupException;
	public VocabularyEntry resolve(String vocabulary, String id) throws VocabularyLookupException;
	public boolean vocabularyAvailable(String vocabulary) throws VocabularyLookupException;
	public VocabularyEntry fetch(VocabularyDefinition vd, String key) throws VocabularyLookupException;
}
