package de.uniba.minf.registry.model.vocabulary;

import java.util.ArrayList;
import java.util.List;

import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.registry.model.definition.BaseDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition;
import de.uniba.minf.registry.model.definition.SimplePropertyDefinition.SIMPLE_TYPES;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper=true)
@Document
public class VocabularyDefinition extends BaseDefinition {
	private static final long serialVersionUID = -5798171298877689887L;
	
	@Override
	public List<PropertyDefinition> getPreviewProperties() {
		List<PropertyDefinition> previewProperties = new ArrayList<>();

		// primaryValue and key are statically defined and thus not in property definition
		previewProperties.add(this.createProperty("key"));
		previewProperties.add(this.createProperty("primaryValue"));
		previewProperties.addAll(super.getPreviewProperties());
		
		return previewProperties;
	}
	
	private PropertyDefinition createProperty(String label) {
		SimplePropertyDefinition p = new SimplePropertyDefinition();
		p.setName(label);
		p.setIdentifier(this.getName() + "." + label);
		p.setType(SIMPLE_TYPES.TEXT);
		return p;
	}
}
