package de.uniba.minf.registry.model.validation.constraints;

import java.util.List;

import am.ik.yavi.core.CustomConstraint;

public class MandatoryConstraint<T> implements CustomConstraint<List<T>> {

    @Override
    public boolean test(List<T> c) {
        return c!=null && !c.isEmpty();
    }

    @Override
    public String messageKey() {
        return "property.mandatory";
    }

    @Override
    public String defaultMessageFormat() {
        return "\"{0}\" is a mandatory property and must be provided";
    }
}