package de.uniba.minf.registry.model.validation;

import java.util.List;

import am.ik.yavi.core.CustomConstraint;
import de.uniba.minf.registry.model.PropertyValue;
import de.uniba.minf.registry.model.definition.EntityDefinition;
import de.uniba.minf.registry.model.definition.PropertyDefinition;
import de.uniba.minf.registry.model.entity.AutoqueryEntityLookupService;
import de.uniba.minf.registry.model.entity.Entity;
import de.uniba.minf.registry.model.vocabulary.ValidationEntityService;
import de.uniba.minf.registry.model.vocabulary.VocabularyLookupService;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class UniqueExternalIdentifierConstraint implements CustomConstraint<Entity> {

	private final VocabularyLookupService vocabularyLookupService;
	private final AutoqueryEntityLookupService autoqueryLookupService;
	private final ValidationEntityService entityService;
	private final EntityDefinition ed;
	private final PropertyDefinition extIdProperty;
	
	public UniqueExternalIdentifierConstraint(EntityDefinition ed, PropertyDefinition extIdProperty, VocabularyLookupService vocabularyLookupService, AutoqueryEntityLookupService autoqueryLookupService, ValidationEntityService entityService) {
		this.ed = ed;  
		this.extIdProperty = extIdProperty;
		this.vocabularyLookupService = vocabularyLookupService;
		this.autoqueryLookupService = autoqueryLookupService;
		this.entityService = entityService;
	}
	
	@Override
	public boolean test(Entity e) {
		// Iterate all property values under a identifier property definition
		List<PropertyValue> checkedValues = e.get(extIdProperty).stream().flatMap(p -> p.valuesAsList().stream()).toList();
		for (PropertyValue checkedValue : checkedValues) {							
			// If there is an entity that uses this identifier which is not the validated entity itself -> fail validation
			if (entityService.findByExternalIdentifier(ed.getName(), checkedValue.asText()).stream().anyMatch(matchE -> !matchE.getEntityId().equals(e.getEntityId()))) {
				return false;
			}
		}
		return true;			
	}
	
    @Override
    public String messageKey() {
        return "value.vocabulary_key_identifier_unique";
    }

    @Override
    public String defaultMessageFormat() {
        return "Property marked as unique and value already in use on another entity";
    }

}
