package de.uniba.minf.registry.model.serialization.base;

import java.io.Serializable;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class SerializationMessage implements Serializable {
	private static final long serialVersionUID = -7281794978141314949L;

	public static SerializationMessage handleMessage(MESSAGE_TYPES type, String message, Object... args) throws SerializationError {
		return handleMessage(type, String.format(message, args));
	}
	
	public static SerializationMessage handleMessage(MESSAGE_TYPES type, String message) throws SerializationError {
		SerializationMessage msg = new SerializationMessage(type, message);
		msg.handle();
		return msg;
	}
	
	public enum MESSAGE_TYPES { NOTICE, WARN, ERROR, FAIL }
	
	private MESSAGE_TYPES type;
	private String message;
	
	public SerializationMessage(MESSAGE_TYPES type, String message) {
		this.type = type; 
		this.message = message;
	}
	
	public void handle() throws SerializationError {
		if (this.type==MESSAGE_TYPES.NOTICE) {
			log.info(this.getMessage());
		} else if (this.type==MESSAGE_TYPES.WARN) {
			log.warn(this.getMessage());
		} else if (this.type==MESSAGE_TYPES.ERROR) {
			log.error(this.getMessage());
		} else {
			log.error(this.getMessage());
			throw new SerializationError(this.getMessage());
		}
	}
	
	
}
