package de.uniba.minf.registry.model.definition;

import de.uniba.minf.registry.RegistryConstants.PropertyCompositionMethods;
import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class RelationPropertyDefinition extends HierarchicalPropertyDefinition {	
	private static final long serialVersionUID = -7111385809713485901L;

	private String relation;
	private EntityRelationDefinition relationDefinition;
	
	@Override
	public PropertyCompositionMethods getCompositionMethod() {
		if (super.getCompositionMethod().equals(PropertyCompositionMethods.DEFAULT)) {
			return PropertyCompositionMethods.COLLECTION;
		}
		return super.getCompositionMethod();
	}
}
