package de.uniba.minf.registry.model;

import org.springframework.data.annotation.Id;

import com.fasterxml.jackson.annotation.JsonIgnore;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.id.ValueMappingId;
import lombok.Data;

@Data
public class ValueMapping implements Identifiable {
	private static final long serialVersionUID = 6225882164988683868L;
	
	@Id
	@JsonIgnore
	private ValueMappingId valueMappingId;
	
	private String assignment;
	private boolean preventResolve;
	
	public String getSourceEntityId() {
		return this.getValueMappingId().getSourceEntityId();
	}
	
	public String getValue() {
		return this.getValueMappingId().getValue();
	}

	@JsonIgnore
	@Override
	public String getUniqueId() {
		return this.getSourceEntityId() + "/" + this.getValue();
	}
}
