package de.uniba.minf.registry.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@EqualsAndHashCode(callSuper=true)
@NoArgsConstructor
public class BooleanPropertyValue extends BasePropertyValue<Boolean> {
	private static final long serialVersionUID = 4783186948763111145L;

	public BooleanPropertyValue(Boolean value) {
		this.setValue(value);
	}
	
	public BooleanPropertyValue(Boolean value, String lang) {
		this.setValue(value);
		this.setLang(lang);
	}

	@Override
	public boolean asBoolean() {
		return this.getValue();
	}
}
