package de.uniba.minf.registry.model;

import java.util.ArrayList;
import java.util.List;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class BlockedPropertyValue implements PropertyValue {
	private static final long serialVersionUID = -308665451667194893L;
	private String blockedValue;
	
	@Override
	public String asText() {
		return blockedValue;
	}
	
	@Override
	public List<PropertyValue> valuesAsList() {
		if (blockedValue==null) {
			return new ArrayList<>(0);
		}
		List<PropertyValue> list = new ArrayList<>(1);
		list.add(this);
		return list;
	}
}
