package de.uniba.minf.registry.model.vocabulary;

import java.util.List;
import java.util.Locale;

import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import com.fasterxml.jackson.annotation.JsonIgnore;

import de.uniba.minf.core.rest.model.Identifiable;
import de.uniba.minf.registry.model.BaseDefinedObject;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@Document
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
@CompoundIndex(def = "{'definitionName': 1, 'key': 1}", unique = true)
public class VocabularyEntry extends BaseDefinedObject implements Identifiable {
	private static final long serialVersionUID = -6473574071976021721L;

	@Indexed
	private String key;
	
	private String primaryValue;
	
	@Indexed
	private String invertsKey;
	
	@Transient
	@JsonIgnore
	private double score;
	
	private List<ValueVariant> variants;
	private List<Reference> references;	
	
	public String getValueVariant(Locale locale) {
		if (variants!=null) {
			return variants.stream().filter(v -> v.getLang().equals(locale.getLanguage())).findAny().map(v -> v.getValue()).orElse(primaryValue);
		}
		return primaryValue;
	}
}
