package de.uniba.minf.registry.model.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import de.uniba.minf.registry.model.validation.ValidationConstants.ValidationMethods;
import de.uniba.minf.registry.model.validation.exception.ValidationConfigurationException;
import lombok.Getter;

public class NumParamConstraint {
	private static final Pattern WITH_NUM_PARAM_PATTERN = Pattern.compile("([^\\(]+)(\\((\\d+)\\))?");
	
	@Getter private String method = null;
	@Getter private Integer num = null;
	
	public NumParamConstraint(String name) {
		Matcher matcher = WITH_NUM_PARAM_PATTERN.matcher(name);
       
        if (matcher.find()) {	            
            if (matcher.groupCount()>0) {
            	method = matcher.group(1);
            }
            if (matcher.groupCount()>2) {
            	num = matcher.group(3)==null ? null : Integer.parseInt(matcher.group(3));
            }
        }
	}
	
	public ValidationMethods getAndAssertValidationMethod() throws ValidationConfigurationException {
		for (ValidationMethods m : ValidationMethods.values()) {
			if (this.methodEquals(m.name())) {
				if (m.getNumArgRequired()) {
					this.assertHasNum();
				}
				return m;
			}
		}
		throw new ValidationConfigurationException("Configured constraint method unknown: " + this.method);
	}
		
	public boolean hasNum() {
		return this.num!=null;
	}
	
	public double numAsDouble() {
		return this.num.doubleValue();
	}
	
	private boolean methodEquals(String methodIgnoreCase) throws ValidationConfigurationException {
		if (this.method==null) {
			throw new ValidationConfigurationException("Configured constraint method cannot be null");
		}
		return this.method.equalsIgnoreCase(methodIgnoreCase);
	}
	
	private boolean assertHasNum() throws ValidationConfigurationException {
		if (this.num==null) {
			throw new ValidationConfigurationException("Configured constraint requires numerical argument, such as " + (this.method!=null ? this.method + "(" : "method(") + "3)");
		}
		return true; 
	}
}
