package de.uniba.minf.registry.model.entity;

import java.util.List;

import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class CachedEntity implements Identifiable {

	private static final long serialVersionUID = -7212337312388176584L;

	private String uniqueId;
	private String entityId;
	
	private String definitionName;
	private long definitionVersion;
	
	private List<PreviewProperty> cachedProperties;
	
	public CachedEntity(Entity e, List<PreviewProperty> cachedProperties) {
		this.setEntityId(e.getEntityId());
		this.setUniqueId(e.getUniqueId());
		this.setDefinitionName(e.getDefinitionName());
		this.setDefinitionVersion(e.getDefinitionVersion());
		this.setCachedProperties(cachedProperties);
	}
}
