package de.uniba.minf.registry.model.definition;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class PropertyDefinitionBlock implements Serializable {
	private static final long serialVersionUID = 22831617284413788L;
	
	private List<PropertyDefinition> properties;
	private String name;
	private String identifier;
	private String messageCode;
	
	public String getMessageCode() {
		if (messageCode!=null) {
			return messageCode;
		}
		if (identifier==null || identifier.startsWith("~")) {
			return identifier;
		}		
		return "~" + identifier;
	}

		
	public boolean isExplicitBlock() {
		return name!=null;
	}
}
