package de.uniba.minf.registry.model.definition;

import java.util.ArrayList;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class HierarchicalPropertyDefinition extends PropertyDefinition {
	private static final int DEFAULT_LIMIT_PREVIEW_PROPERTIES = 2;
	
	private static final long serialVersionUID = 4345479614817233156L;
	private List<PropertyDefinition> properties;
	private List<PropertyDefinition> previewProperties;
	
	public List<PropertyDefinition> getPreviewProperties() {
		if (previewProperties!=null && !previewProperties.isEmpty()) {
			return previewProperties;
		}
		if (properties!=null && !properties.isEmpty()) {
			return properties.stream().filter(p -> !HierarchicalPropertyDefinition.class.isAssignableFrom(p.getClass())).limit(DEFAULT_LIMIT_PREVIEW_PROPERTIES).toList();
		}
		return new ArrayList<>(0);
	}
}
