package de.uniba.minf.registry.model.definition;

import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class AutofillPropertyDefinition implements Serializable {
	private static final long serialVersionUID = -3039156368890140545L;
	
	String propertyName;
	String externalName;
	
	public boolean filterApplies(String extPropertyName) {
		if (externalName!=null) { 
			return externalName.equals(extPropertyName);
		}
		return propertyName.equals(extPropertyName);
	}
}