package de.uniba.minf.registry.model;

import java.util.ArrayList;
import java.util.List;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class PropertyValueList implements PropertyValue {
	private static final long serialVersionUID = 7421623237153702261L;
	
	private List<PropertyValue> values;
	
	public PropertyValueList(List<? extends PropertyValue> value) {
		values = new ArrayList<>(value);
	}
	
	public void add(PropertyValue value) {
		this.ensureInitialized();
		this.values.add(value);
	}
	
	public void addAll(List<? extends PropertyValue> value) {
		this.ensureInitialized();
		this.values.addAll(value);
	}
	
	private void ensureInitialized() {
		if (values==null) {
			values = new ArrayList<>();
		}
	}
	
	public boolean isEmpty() {
		return values==null || values.isEmpty();
	}

	@Override
	public String asText() {
		if (values==null || values.isEmpty()) {
			return null;
		}
		StringBuilder bldr = new StringBuilder();
		for (int i=0; i<values.size(); i++) {
			bldr.append(values.get(i).asText());
			if (i<values.size()-1) {
				bldr.append(", ");
			}
		}
		return bldr.toString();
	}

	@Override
	public boolean isMultivalue() {
		return true;
	}
		
	@Override
	public List<PropertyValue> valuesAsList() {
		if (values==null) {
			return new ArrayList<>(0);
		}
		return this.values;
	}
	
	@Override
	public boolean asBoolean() {
		if (values==null || values.isEmpty()) {
			return false;
		}
		boolean b = true;
		for (PropertyValue v : values) {
			b = b && v.asBoolean();
		}
		return b;
	}

	@Override public String getLang() { return null; }
}
