package de.uniba.minf.registry.model;

import java.time.Instant;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;
import lombok.ToString;

@Data
@Document
@ToString
public class Import implements Identifiable {
	private static final long serialVersionUID = 2356655282680005127L;

	@Id
	private String uniqueId;
	
	private String templateId;
		
	private Instant creationInstant;
	
	@Indexed
	private String sourceEntityId;
	
	@Indexed
	private String userUniqueId;
}
