package de.uniba.minf.registry.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=false)
public class CompositePropertyImpl extends PropertyImpl {
	
	private static final long serialVersionUID = -8393661481293626596L;

	@Transient
	private boolean layersOnly;
	
	@Transient
	@JsonIgnore
	private Map<String, Property> layeredPropertyMap;	// All available layer properties
	
	private List<String> propertyLayerEntityIds;		// IDs of the active layers
	
	@Override 
	public boolean isComposite() { return true; }
	
	@Transient
	public boolean hasLayeredData() {
		return this.propertyLayerEntityIds!=null && !this.propertyLayerEntityIds.isEmpty();
	}
	
	public List<String> getLayersForPropertyValue(Object value) {
		if (value==null || layeredPropertyMap==null) {
			return new ArrayList<>(0);
		}
		List<String> layerIds = new ArrayList<>();
		for (Entry<String, Property> propertyLayerEntry : layeredPropertyMap.entrySet()) {
			if (propertyLayerEntry.getValue().valuesAsList().stream().anyMatch(v -> v.asText().equals(value.toString()))) {
				layerIds.add(propertyLayerEntry.getKey());
			}
		}
		return layerIds;
	}
	
	@Override 
	public boolean isEmpty() { 
		return super.isEmpty() && !this.hasLayeredData();
	}
	
	public Property toRegularProperty() {
		return toRegularProperty(this);
	}
	
	public static Property toRegularProperty(Property pComp) {
		Property p = new PropertyImpl();
		p.setDefinition(pComp.getDefinition());
		p.setLabel(pComp.getLabel());
		p.setValue(pComp.getValue());
		p.setPropertyKeyOrder(pComp.getPropertyKeyOrder());
		
		if (pComp.getProperties()!=null) {
			p.setProperties(new ArrayList<>(pComp.getProperties().size()));
			for (PropertyList plCompSub : pComp.getProperties()) {
				PropertyList plSub = new PropertyList();
				for (Property pCompSub : plCompSub.getProperties()) {
					plSub.add(toRegularProperty(pCompSub));
				}
				p.getProperties().add(plSub);
			}
		}
		return p;
	}
}
