package de.uniba.minf.registry.model;

import java.time.Instant;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;

import de.uniba.minf.core.rest.model.Identifiable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public abstract class BaseDefinedObject extends PropertyList implements Identifiable {
	private static final long serialVersionUID = -7366410799469808617L;

	@Id
	private String uniqueId;
	
	@Indexed
	private String definitionName;
	private long definitionVersion;
		
	private Instant creationInstant;
	
	private String userUniqueId;
	
	private boolean readOnly;
	private boolean draft;
	private boolean template;
	private boolean deleted;
		
	@Indexed
	private String importId;
	
	@Indexed
	private String sourceEntityId;
	
	private String sourceLabel;
	private String sourceTitle;
	
	public boolean isPublished() { return !this.draft; }
	public void setPublished(boolean published) { this.draft = !published; }
}
