package de.uniba.minf.registry.model.entity;

import java.io.Serializable;
import java.time.Instant;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

import de.uniba.minf.registry.model.PropertyList;
import jakarta.validation.constraints.NotNull;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Data
@Document
@EqualsAndHashCode(callSuper=true)
@ToString(callSuper = true)
public class EntityRelation extends PropertyList implements Serializable {
	private static final long serialVersionUID = -4698722200982783667L;
	
	public enum MainRelationTypes { SELF, CHILD, CUSTOM, FREETEXT }
	
	@Id
	private String uniqueId;
	
	@Indexed
	@NotNull
	private String fromUniqueId;
	
	@Indexed
	@NotNull
    private String toUniqueId;

	@Indexed
	@NotNull
	private String fromEntityId;
	
	@Indexed
	@NotNull
    private String toEntityId;	
	
	private String fromPath;
	private String toPath;
	
	private MainRelationTypes mainRelationType;
	
	private String typeVocabulary;
	private String typeVocabularyKey;
	
	private Instant creationInstant;
	private String userUniqueId;
	
	public boolean isInverseForEntity(Entity e) {
		return !this.getFromUniqueId().equals(e.getUniqueId());
	}
	
	public String getRelatedUniqueIdForEntity(Entity e) {
		return isInverseForEntity(e) ?  this.getFromUniqueId() : this.getToUniqueId();
	}
	
	public String getPathForEntity(Entity e) {
		return !isInverseForEntity(e) ?  this.getFromPath() : this.getToPath();
	}	
}
