package de.uniba.minf.registry.model.definition;

import java.util.List;

import org.springframework.data.annotation.Transient;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class VocabularyPropertyDefinition extends PropertyDefinition {
	private static final long serialVersionUID = 7972999599937195954L;
	private String vocabulary;
	
	private boolean strict;
	private boolean radio;
	private boolean query;
	private boolean autoQuery;
	private boolean entity;
	
	private String defaultEntry;
	
	private String entityRelationVocabulary;
	private String entityRelationType;
	
	private List<AutofillPropertyDefinition> autofillProperties;
	
	@Transient
	@JsonIgnore
	private List<String> entryKeys;
	
	public boolean isAutofill() {
		return autofillProperties!=null && !autofillProperties.isEmpty();
	}
	
	public boolean isAutofillAll() {
		return autofillProperties!=null && autofillProperties.size()==1 && autofillProperties.get(0).getPropertyName().equals("true");
	}
}
